/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.contact.ContactMergerator;
import com.openexchange.groupware.contact.IDComparator;
import com.openexchange.groupware.container.Contact;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.util.Comparator;
import java.util.LinkedList;
import junit.framework.TestCase;

public class ContactMergeratorTest
extends TestCase {
    private SearchIterator<Contact> contacts(int ... ids) {
        LinkedList<Contact> retval = new LinkedList<Contact>();
        for (int id : ids) {
            Contact contact = new Contact();
            contact.setObjectID(id);
            retval.add(contact);
        }
        return new SearchIteratorAdapter(retval.iterator());
    }

    public void testSortIntegerColumn() throws Exception {
        SearchIterator<Contact> c1 = this.contactsWithIDs(11, 101, 1001);
        SearchIterator<Contact> c2 = this.contactsWithIDs(21, 22, 23);
        SearchIterator<Contact> c3 = this.contactsWithIDs(31, 32, 33);
        SearchIterator<Contact> c4 = this.contactsWithIDs(new int[0]);
        ContactMergerator merged = new ContactMergerator((Comparator)new IDComparator(), new SearchIterator[]{c1, c2, c3, c4});
        this.assertIDs(merged, 11, 21, 22, 23, 31, 32, 33, 101, 1001);
    }

    private void assertIDs(ContactMergerator merged, int ... ids) throws Exception {
        int index = 0;
        while (merged.hasNext()) {
            Contact c = merged.next();
            int currentId = ids[index++];
            ContactMergeratorTest.assertEquals((String)("Unexpected element at index: " + (index - 1)), (int)currentId, (int)c.getObjectID());
        }
        ContactMergeratorTest.assertEquals((int)ids.length, (int)index);
    }

    private SearchIterator<Contact> contactsWithIDs(int ... ids) {
        LinkedList<Contact> retval = new LinkedList<Contact>();
        for (int id : ids) {
            Contact contact = new Contact();
            contact.setObjectID(id);
            retval.add(contact);
        }
        return new SearchIteratorAdapter(retval.iterator());
    }
}

