/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.Config;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.carddav.CardDAVTest;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.w3c.dom.Node;

public class CurrentUserPrincipalTest
extends CardDAVTest {
    public CurrentUserPrincipalTest(String name) {
        super(name);
    }

    public void testDiscoverCurrentUserPrincipal() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.CURRENT_USER_PRINCIPAL);
        props.add(PropertyNames.PRINCIPAL_URL);
        props.add(PropertyNames.RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/", 0, props, 0);
        MultiStatusResponse response = CurrentUserPrincipalTest.assertSingleResponse(super.getWebDAVClient().doPropFind(propFind));
        String principal = super.extractHref(PropertyNames.CURRENT_USER_PRINCIPAL, response);
        CurrentUserPrincipalTest.assertTrue((String)("username not found in href child of " + PropertyNames.CURRENT_USER_PRINCIPAL), (boolean)principal.contains(Config.getUsername()));
        String principalURL = super.extractHref(PropertyNames.PRINCIPAL_URL, response);
        CurrentUserPrincipalTest.assertTrue((String)("username not found in href child of " + PropertyNames.PRINCIPAL_URL), (boolean)principalURL.contains(Config.getUsername()));
        Node node = super.extractNodeValue(PropertyNames.RESOURCETYPE, response);
        CurrentUserPrincipalTest.assertMatches(PropertyNames.COLLECTION, node);
    }

    public void testDiscoverCurrentUserPrincipalAtWellKnown() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.CURRENT_USER_PRINCIPAL);
        props.add(PropertyNames.PRINCIPAL_URL);
        props.add(PropertyNames.RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/.well-known/carddav", 0, props, 0);
        super.getWebDAVClient().doPropFind(propFind, 404);
    }
}

