/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug21794Test
extends CalDAVTest {
    public Bug21794Test(String name) {
        super(name);
    }

    public void testDeclineImportedAppointment() throws Exception {
        String uid = "WEBEX-MEETING CENTER-6.0292133-" + new Date().getTime();
        String resourceName = uid.replace(".", "");
        Date start = TimeTools.D("next monday at 15:30");
        Date end = TimeTools.D("next monday at 16:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//iCal 5.0.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Amsterdam\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Amsterdam:" + Bug21794Test.format(end, "Europe/Amsterdam") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "ORGANIZER;CN=\"webex\":MAILTO:messenger@example.com" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug21794Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:https://open-xchange.webex.com/open-xchange-en" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:Agorum Integration" + "\r\n" + "DTSTART;TZID=Europe/Amsterdam:" + Bug21794Test.format(start, "Europe/Amsterdam") + "\r\n" + "CREATED:" + Bug21794Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "ATTENDEE;CN=\"Open-Xchange Presenter\";CUTYPE=INDIVIDUAL;ROLE=REQ-PARTICIP" + "\r\n" + " ANT:MAILTO:webmeeting1@example.com" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Bug21794Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(resourceName, iCal));
        Appointment appointment = super.getAppointment(uid);
        Bug21794Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = super.get(resourceName, null);
        Bug21794Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug21794Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        List<SimpleICal.Property> attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        block0: for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            for (Map.Entry<String, String> attribute : property.getAttributes().entrySet()) {
                if (!attribute.getKey().equals("PARTSTAT")) continue;
                attribute.setValue("DECLINED");
                break block0;
            }
        }
        Bug21794Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Bug21794Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        UserParticipant[] users = appointment.getUsers();
        Bug21794Test.assertNotNull((String)"appointment has no users", (Object)users);
        UserParticipant declinedPartipant = null;
        for (UserParticipant user : users) {
            if (this.getAJAXClient().getValues().getUserId() != user.getIdentifier()) continue;
            declinedPartipant = user;
            break;
        }
        Bug21794Test.assertNotNull((String)"declining participant not found", declinedPartipant);
        Bug21794Test.assertEquals((String)"confirmation status wrong", (int)2, (int)declinedPartipant.getConfirm());
        iCalResource = super.get(resourceName, iCalResource.getETag());
        Bug21794Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug21794Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        SimpleICal.Property attendee = null;
        attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            attendee = property;
            break;
        }
        Bug21794Test.assertNotNull((String)"declining attendee not found", attendee);
        Bug21794Test.assertEquals((String)"partstat status wrong", (String)"DECLINED", (String)attendee.getAttribute("PARTSTAT"));
    }
}

