/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user;

import com.openexchange.ajax.config.BetaWriter;
import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.user.actions.SetAttributeRequest;
import com.openexchange.ajax.user.actions.SetAttributeResponse;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.RandomString;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug26354Test
extends AbstractAJAXSession {
    private static final String ATTRIBUTE_NAME = "testForBug26354";
    private static final int ITERATIONS = 100;
    private final BetaWriter[] writer = new BetaWriter[2];
    private final Thread[] thread = new Thread[this.writer.length];
    private AJAXClient client;
    private int userId;
    private boolean origValue;

    public Bug26354Test(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        int i;
        super.setUp();
        this.client = this.getClient();
        this.userId = this.client.getValues().getUserId();
        this.origValue = this.client.execute(new GetRequest(Tree.Beta)).getBoolean();
        for (i = 0; i < this.writer.length; ++i) {
            this.writer[i] = new BetaWriter(AJAXClient.User.User1);
            this.thread[i] = new Thread(this.writer[i]);
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].start();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        int i;
        for (i = 0; i < this.writer.length; ++i) {
            this.writer[i].stop();
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].join();
        }
        for (i = 0; i < this.writer.length; ++i) {
            Throwable throwable = this.writer[i].getThrowable();
            Bug26354Test.assertNull((String)("Expected no Throwable, but there is one: " + throwable), (Object)throwable);
        }
        this.client.execute(new SetRequest(Tree.Beta, Autoboxing.B((boolean)this.origValue)));
        super.tearDown();
    }

    @Test
    public void testSetAttribute() throws Throwable {
        boolean stop = false;
        for (int i = 0; i < 100 && !stop; ++i) {
            String value = RandomString.generateChars(64);
            SetAttributeResponse response = this.client.execute(new SetAttributeRequest(this.userId, ATTRIBUTE_NAME, value, false));
            Bug26354Test.assertTrue((String)"Setting the attribute was not successful.", (boolean)response.isSuccess());
            for (int j = 0; j < this.writer.length; ++j) {
                stop = stop || null != this.writer[j].getThrowable();
            }
        }
    }
}

