/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.task.AbstractTaskTestForAJAXClient;
import com.openexchange.groupware.tasks.TestTask;
import org.junit.Test;

public class TaskRecurrenceTest
extends AbstractTaskTestForAJAXClient {
    public TaskRecurrenceTest(String name) {
        super(name);
    }

    @Test
    public void testInsertDailyRecurrenceTask() {
        TestTask todaysTask = this.getNewTask("This I'll do every day from now on. Promised.").startsToday().everyDay().checkConsistencyOf(1, 2);
        this.runSimpleInsertTest(todaysTask);
    }

    @Test
    public void testInsertAndUpdateDailyRecurrenceTask() {
        TestTask todaysTask = this.getNewTask("This I'll do every day from now on. Promised.").startsToday().everyDay().checkConsistencyOf(1, 2);
        TestTask tomorrowsTask = todaysTask.clone().startsTomorrow().checkConsistencyOf(1, 2);
        this.runInsertAndUpdateTest(todaysTask, tomorrowsTask, 201, 202);
    }

    @Test
    public void testWeeklyRecurrence() {
        TestTask tomorrowsTask = this.getNewTask("This, I'll do every week from now. Well, from tomorrow. Maybe.").startsTomorrow().everyWeek().checkConsistencyOf(1, 2);
        this.runSimpleInsertTest(tomorrowsTask);
    }

    @Test
    public void testInsertAndUpdateWeeklyRecurrenceTask() {
        TestTask tomorrowsTask = this.getNewTask("This, I'll do every week from now. Well, from tomorrow. Maybe.").startsTomorrow().everyWeek().checkConsistencyOf(1, 2);
        TestTask laterTask = tomorrowsTask.clone().startsTheFollowingDay().checkConsistencyOf(1, 2);
        this.runInsertAndUpdateTest(tomorrowsTask, laterTask, 201, 202, 212);
    }

    @Test
    public void testWeeklyRecurrence2() {
        TestTask trainingDays = this.getNewTask("Training days").startsThisWeek(4).startsAtNoon().endsThisWeek(4).endsInTheEvening().everyWeekOn(4, 16, 64).checkConsistencyOf(1, 2);
        this.runSimpleInsertTest(trainingDays);
    }

    @Test
    public void testInsertAndUpdateWeeklyRecurrence2Task() {
        TestTask trainingDays = this.getNewTask("Training days").startsThisWeek(4).startsAtNoon().endsThisWeek(4).endsInTheEvening().everyWeekOn(4, 16, 64).checkConsistencyOf(1, 2);
        TestTask laterTrainingDays = trainingDays.clone().everyWeekOn(4, 16, 1);
        this.runInsertAndUpdateTest(trainingDays, laterTrainingDays, 212);
    }

    @Test
    public void testMonthlyRecurrence() {
        TestTask myAAMeeting = this.getNewTask("my AA meeting").startsWeekOfMonthOnDay(1, 2).everyMonthOnNthWeekday(1, 2).everyOtherMonth().checkConsistencyOf(1, 2);
        this.runSimpleInsertTest(myAAMeeting);
    }

    @Test
    public void testInsertAndUpdateMonthlyRecurrence() {
        TestTask myAAMeeting = this.getNewTask("my AA meeting").startsThisWeek(2).startsWeekOfMonth(1).everyMonthOnNthWeekday(1, 2).everyOtherMonth().checkConsistencyOf(1, 2);
        TestTask myPostponedAAMeeting = myAAMeeting.clone().startsThisWeek(2).startsWeekOfMonth(2).everyMonthOnNthWeekday(2, 2).checkConsistencyOf(1, 2);
        this.runInsertAndUpdateTest(myAAMeeting, myPostponedAAMeeting, 213, 201, 202);
    }

    @Test
    public void testInsertMonthlyRecurrence2() {
        TestTask myAAMeeting = this.getNewTask("my other AA group meeting").startsThisMonth(6).everyMonth().onDay(6).checkConsistencyOf(1, 2);
        this.runSimpleInsertTest(myAAMeeting);
    }

    @Test
    public void testInsertAndUpdateMonthlyRecurrence2() {
        TestTask myAAMeeting = this.getNewTask("my other AA group meeting").startsThisMonth(6).everyMonth().onDay(6).checkConsistencyOf(1, 2);
        TestTask myPostponedAAMeeting = myAAMeeting.clone().startsThisMonth(5).onDay(5).checkConsistencyOf(1, 2);
        this.runInsertAndUpdateTest(myAAMeeting, myPostponedAAMeeting, 212, 213, 201);
    }

    @Test
    public void failtestInsertYearlyRecurrence() {
        TestTask organizeSilvesterParty = this.getNewTask("Have to organize Silvester party").everyYear().onDay(30).inMonth(12).checkConsistencyOf(1, 2);
        this.runSimpleInsertTest(organizeSilvesterParty);
    }

    @Test
    public void failtestInsertAndUpdateYearlyRecurrence() {
        TestTask organizeSilvesterParty = this.getNewTask("Have to organize Silvester party").everyYear().onDay(30).inMonth(12).checkConsistencyOf(1, 2);
        TestTask organizeSilvesterPartyEarlier = organizeSilvesterParty.clone().onDay(29).checkConsistencyOf(1, 2);
        this.runInsertAndUpdateTest(organizeSilvesterParty, organizeSilvesterPartyEarlier, 212);
    }

    @Test
    public void failtestInsertYearlyRecurrence2() {
        TestTask breakNewYearsVows = this.getNewTask("Forget New Year's vows now").everyYear().inMonth(1).onWeekDays(2).checkConsistencyOf(1, 2);
        this.runSimpleInsertTest(breakNewYearsVows);
    }

    @Test
    public void failtestInsertAndUpdateYearlyRecurrence2() {
        TestTask breakNewYearsVows = this.getNewTask("Forget New Year's vows now").everyYear().inMonth(1).onWeekDays(2).checkConsistencyOf(1, 2);
        TestTask breakNewYearsVowsLater = breakNewYearsVows.clone().onWeekDays(4).checkConsistencyOf(1, 2);
        this.runInsertAndUpdateTest(breakNewYearsVows, breakNewYearsVowsLater, 201);
    }
}

