/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.TaskUpdatesResponse;
import com.openexchange.ajax.task.actions.UpdatesRequest;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import java.util.TimeZone;

public class Bug10119Test
extends AbstractTaskTest {
    public Bug10119Test(String name) {
        super(name);
    }

    public void testFunambol() throws Throwable {
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateTaskFolder();
        TimeZone timeZone = client.getValues().getTimeZone();
        Date beforeInsert = new Date(client.getValues().getServerTime().getTime() - 1L);
        InsertRequest[] initialInserts = new InsertRequest[2];
        for (int i = 0; i < initialInserts.length; ++i) {
            Task task = new Task();
            task.setParentFolderID(folderId);
            task.setTitle("Initial" + (i + 1));
            initialInserts[i] = new InsertRequest(task, timeZone);
        }
        MultipleResponse mInsert = (MultipleResponse)client.execute(MultipleRequest.create(initialInserts));
        int[] columns = new int[]{200, 1, 20};
        UpdatesRequest uRequest = new UpdatesRequest(folderId, columns, 0, null, new Date(beforeInsert.getTime() - 1L));
        TaskUpdatesResponse uResponse = client.execute(uRequest);
        Bug10119Test.assertTrue((String)("Can't find initial inserts. Only found " + uResponse.size() + " changed tasks."), (uResponse.size() >= 2 ? 1 : 0) != 0);
        InsertResponse secondInsert = (InsertResponse)((Object)mInsert.getResponse(1));
        client.execute(new DeleteRequest(folderId, secondInsert.getId(), secondInsert.getTimestamp()));
        Task task = new Task();
        task.setParentFolderID(folderId);
        task.setTitle("anotherInsert");
        InsertResponse iResponse = client.execute(new InsertRequest(task, timeZone));
        TaskUpdatesResponse uResponse2 = client.execute(new UpdatesRequest(folderId, columns, 0, null, uResponse.getTimestamp(), AbstractUpdatesRequest.Ignore.NONE));
        Bug10119Test.assertTrue((String)"Can't get created and deleted item.", (uResponse2.size() >= 2 ? 1 : 0) != 0);
        DeleteRequest[] deletes = new DeleteRequest[2];
        InsertResponse firstInsert = (InsertResponse)((Object)mInsert.getResponse(0));
        deletes[0] = new DeleteRequest(folderId, firstInsert.getId(), firstInsert.getTimestamp());
        deletes[1] = new DeleteRequest(folderId, iResponse.getId(), iResponse.getTimestamp());
        client.execute(MultipleRequest.create(deletes));
    }
}

