/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.simple;

import com.openexchange.ajax.simple.SimpleOXClient;
import com.openexchange.ajax.simple.SimpleOXModule;
import com.openexchange.ajax.simple.SimpleResponse;
import com.openexchange.test.json.JSONAssertion;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.json.JSONObject;

public class AbstractSimpleClientTest
extends TestCase {
    protected static final String USER1 = "login";
    protected static final String USER2 = "seconduser";
    protected static final String USER3 = "thirdlogin";
    protected static final String USER4 = "fourthlogin";
    protected Properties ajaxProperties;
    protected SimpleOXClient currentClient;
    protected SimpleOXModule currentModule;
    protected SimpleResponse lastResponse;
    private final Map<String, SimpleOXClient> authenticatedClients = new HashMap<String, SimpleOXClient>();
    protected JSONObject rawResponse;

    public AbstractSimpleClientTest() {
    }

    public AbstractSimpleClientTest(String name) {
        super(name);
    }

    public SimpleOXClient createClient() throws Exception {
        Properties properties = this.getAJAXProperties();
        String host = properties.getProperty("hostname");
        boolean secure = "https".equalsIgnoreCase(properties.getProperty("protocol"));
        this.currentClient = new SimpleOXClient(host, secure);
        return this.currentClient;
    }

    public SimpleOXClient as(String user) throws Exception {
        if (this.authenticatedClients.containsKey(user)) {
            this.currentClient = this.authenticatedClients.get(user);
        } else {
            this.createClient();
            String[] credentials = this.credentials(user);
            this.currentClient.login(credentials[0], credentials[1]);
            this.authenticatedClients.put(user, this.currentClient);
        }
        return this.currentClient;
    }

    public SimpleOXClient asUser(String user) throws Exception {
        return this.as(user);
    }

    public JSONObject raw(String action, Object ... parameters) throws Exception {
        this.rawResponse = this.currentModule.raw(action, parameters);
        return this.rawResponse;
    }

    public JSONObject rawGeneral(String module, String action, Object ... parameters) throws Exception {
        this.rawResponse = this.currentClient.raw(module, action, parameters);
        return this.rawResponse;
    }

    public SimpleResponse call(String action, Object ... parameters) throws Exception {
        this.lastResponse = this.currentModule.call(action, parameters);
        return this.lastResponse;
    }

    public SimpleResponse callGeneral(String module, String action, Object ... parameters) throws Exception {
        this.lastResponse = this.currentClient.call(module, action, parameters);
        return this.lastResponse;
    }

    public SimpleOXModule module(String module) {
        this.currentModule = this.currentClient.getModule(module);
        return this.currentModule;
    }

    public SimpleOXModule inModule(String module) {
        return this.module(module);
    }

    public static void assertNoError(SimpleResponse response) {
        AbstractSimpleClientTest.assertFalse((String)response.getError(), (boolean)response.hasError());
    }

    public void assertNoError() {
        AbstractSimpleClientTest.assertNoError(this.lastResponse);
    }

    public static void assertError(SimpleResponse response) {
        AbstractSimpleClientTest.assertTrue((boolean)response.hasError());
    }

    public void assertError() {
        AbstractSimpleClientTest.assertError(this.lastResponse);
    }

    public Map<String, Object> details() {
        return this.lastResponse.getObjectData();
    }

    public List<List<Object>> list() {
        return this.lastResponse.getListData();
    }

    public void assertDataIs(Object expected) {
        AbstractSimpleClientTest.assertEquals((Object)expected, (Object)this.lastResponse.getData());
    }

    public String[] credentials(String user) throws Exception {
        Properties properties = this.getAJAXProperties();
        return new String[]{properties.getProperty(user) + "@" + properties.getProperty("contextName"), properties.getProperty("password")};
    }

    protected Properties getAJAXProperties() throws Exception {
        if (this.ajaxProperties != null) {
            return this.ajaxProperties;
        }
        String testPropFile = System.getProperty("test.propfile", "conf/test.properties");
        Properties testProperties = this.load(testPropFile);
        this.ajaxProperties = this.load(testProperties.getProperty("ajaxPropertiesFile"));
        return this.ajaxProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(String testPropFile) throws FileNotFoundException, IOException {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            is = new FileInputStream(testPropFile);
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void assertRaw(JSONAssertion assertion) {
        JSONAssertion.assertValidates(assertion, this.rawResponse);
    }
}

