/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public final class SendTest
extends AbstractMailTest {
    private MailTestManager manager;

    public SendTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = new MailTestManager(this.client, false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.manager.cleanUp();
        super.tearDown();
    }

    public void testSend() throws Throwable {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        String mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
        SendResponse response = Executor.execute(this.getSession(), new SendRequest(mailObject_25kb));
        SendTest.assertTrue((String)"Send request failed", (response.getFolderAndID() != null && response.getFolderAndID().length > 0 ? 1 : 0) != 0);
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
    }

    public void testSendWithManager() throws OXException, IOException, SAXException, JSONException {
        UserValues values = this.client.getValues();
        TestMail mail = new TestMail();
        mail.setSubject("Test sending with manager");
        mail.setFrom(values.getSendAddress());
        mail.setTo(Arrays.asList(values.getSendAddress()));
        mail.setContentType(MailContentType.PLAIN.toString());
        mail.setBody("This is the message body.");
        mail.sanitize();
        TestMail inSentBox = this.manager.send(mail);
        SendTest.assertFalse((String)"Sending resulted in error", (boolean)this.manager.getLastResponse().hasError());
        SendTest.assertEquals((String)"Mail went into inbox", (String)values.getSentFolder(), (String)inSentBox.getFolder());
    }

    public void testSendUnicode() throws Throwable {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        String mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
        JSONObject jMail = new JSONObject(mailObject_25kb);
        JSONObject jAttach = jMail.getJSONArray("attachments").getJSONObject(0);
        jAttach.put("content", (Object)"Pile of poo \ud83d\udca9");
        SendResponse response = Executor.execute(this.getSession(), new SendRequest(jMail.toString(true)));
        String[] folderAndID = response.getFolderAndID();
        SendTest.assertTrue((String)"Send request failed", (folderAndID != null && folderAndID.length > 0 ? 1 : 0) != 0);
        if (null != folderAndID) {
            GetResponse getResponse = Executor.execute(this.getSession(), new GetRequest(folderAndID[0], folderAndID[1]));
            String content = getResponse.getAttachments().getJSONObject(0).getString("content");
            SendTest.assertTrue((String)"Content is empty", (null != content && content.length() > 0 ? 1 : 0) != 0);
            int pos = content.indexOf("Pile of poo ");
            SendTest.assertTrue((String)"Content is empty", (pos >= 0 ? 1 : 0) != 0);
            pos += 12;
            SendTest.assertEquals((String)"Missing \\uD83D unicode", (int)55357, (int)content.charAt(pos++));
            SendTest.assertEquals((String)"Missing \\uDCA9 unicode", (int)56489, (int)content.charAt(pos++));
        }
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
    }
}

