/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.importexport.actions.CSVImportRequest;
import com.openexchange.ajax.importexport.actions.CSVImportResponse;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.ajax.importexport.actions.OutlookCSVImportRequest;
import com.openexchange.ajax.importexport.actions.OutlookCSVImportResponse;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.tools.versit.ICalendar;
import com.openexchange.tools.versit.ObjectDefinition;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class Tools {
    private Tools() {
    }

    public static CSVImportResponse importCSV(AJAXClient client, CSVImportRequest request) throws OXException, IOException, SAXException, JSONException {
        return Executor.execute(client, request);
    }

    public static ICalImportResponse importICal(AJAXClient client, ICalImportRequest request) throws OXException, IOException, SAXException, JSONException {
        return Executor.execute(client, request);
    }

    public static VCardImportResponse importVCard(AJAXClient client, VCardImportRequest request) throws OXException, IOException, SAXException, JSONException {
        return Executor.execute(client, request);
    }

    public static OutlookCSVImportResponse importOutlookCSV(AJAXClient client, OutlookCSVImportRequest request) throws OXException, IOException, SAXException, JSONException {
        return (OutlookCSVImportResponse)((Object)Executor.execute(client, request));
    }

    public static InputStream toICal(AJAXClient client, Appointment appointment) throws OXException, IOException, SAXException, JSONException, ConverterException {
        ObjectDefinition definition = ICalendar.vEvent2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OXContainerConverter conv = new OXContainerConverter(client.getValues().getTimeZone(), client.getValues().getDefaultAddress());
        VersitObject versit = conv.convertAppointment(appointment);
        VersitDefinition.Writer writer = definition.getWriter((OutputStream)baos, "UTF-8");
        VersitObject container = OXContainerConverter.newCalendar((String)"2.0");
        definition.writeProperties(writer, container);
        definition.write(writer, versit);
        definition.writeEnd(writer, container);
        baos.flush();
        writer.flush();
        conv.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

