/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.group.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.group.actions.AbstractGroupRequest;
import com.openexchange.ajax.group.actions.DeleteParser;
import com.openexchange.ajax.group.actions.DeleteResponse;
import com.openexchange.group.Group;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeleteRequest
extends AbstractGroupRequest<DeleteResponse> {
    private final int groupId;
    private final Date lastModified;
    private final boolean failOnError;

    public DeleteRequest(int groupId, Date lastModified, boolean failOnError) {
        this.groupId = groupId;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(int groupId, Date lastModified) {
        this(groupId, lastModified, true);
    }

    public DeleteRequest(Group group, boolean failOnError) {
        this(group.getIdentifier(), group.getLastModified(), failOnError);
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", this.groupId);
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("timestamp", this.lastModified)};
    }

    public DeleteParser getParser() {
        return new DeleteParser(this.failOnError);
    }
}

