/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.AbstractObjectCountTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.util.Random;
import org.json.JSONException;
import org.junit.Test;

public final class TaskObjectCountTest
extends AbstractObjectCountTest {
    private static final Random rand = new Random(System.currentTimeMillis());

    public TaskObjectCountTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPrivateFolder() throws Exception {
        FolderTestManager ftm = new FolderTestManager(this.client1);
        try {
            int folderId = TaskObjectCountTest.createPrivateFolder(this.client1, ftm, 1).getObjectID();
            Folder folder = TaskObjectCountTest.getFolder(this.client1, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            int numTasks = rand.nextInt(20) + 1;
            TaskObjectCountTest.createTasks(this.client1, folderId, numTasks);
            folder = TaskObjectCountTest.getFolder(this.client1, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count", (int)numTasks, (int)folder.getTotal());
        }
        finally {
            ftm.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPublicFolder() throws Exception {
        FolderTestManager ftm = new FolderTestManager(this.client1);
        FolderObject created = TaskObjectCountTest.createPublicFolder(this.client1, 1, this.client2.getValues().getUserId());
        try {
            int folderId = created.getObjectID();
            Folder folder = TaskObjectCountTest.getFolder(this.client1, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            int numTasks1 = rand.nextInt(20) + 1;
            int numTasks2 = rand.nextInt(20) + 1;
            TaskObjectCountTest.createTasks(this.client1, folderId, numTasks1);
            TaskObjectCountTest.createTasks(this.client2, folderId, numTasks2);
            folder = TaskObjectCountTest.getFolder(this.client2, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count for public folder reader.", (int)numTasks2, (int)folder.getTotal());
            folder = TaskObjectCountTest.getFolder(this.client1, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count for public folder creator.", (int)(numTasks1 + numTasks2), (int)folder.getTotal());
        }
        finally {
            ftm.deleteFolderOnServer(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInSharedFolder() throws Exception {
        FolderTestManager ftm = new FolderTestManager(this.client1);
        FolderObject created = TaskObjectCountTest.createSharedFolder(this.client1, 1, this.client2.getValues().getUserId());
        try {
            int folderId = created.getObjectID();
            Folder folder = TaskObjectCountTest.getFolder(this.client1, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            int numTasks1 = rand.nextInt(20) + 1;
            int numTasks2 = rand.nextInt(20) + 1;
            TaskObjectCountTest.createTasks(this.client1, folderId, numTasks1, true);
            TaskObjectCountTest.createTasks(this.client2, folderId, numTasks2);
            folder = TaskObjectCountTest.getFolder(this.client2, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count for shared folder reader.", (int)numTasks2, (int)folder.getTotal());
            folder = TaskObjectCountTest.getFolder(this.client1, folderId, DEFAULT_COLUMNS);
            TaskObjectCountTest.assertEquals((String)"Wrong object count for shared folder owner.", (int)(numTasks1 + numTasks2), (int)folder.getTotal());
        }
        finally {
            ftm.deleteFolderOnServer(created);
        }
    }

    private static void createTasks(AJAXClient client, int folderId, int count) throws OXException, IOException, JSONException {
        TaskObjectCountTest.createTasks(client, folderId, count, false);
    }

    private static void createTasks(AJAXClient client, int folderId, int count, boolean privat) throws OXException, IOException, JSONException {
        InsertRequest[] inserts = new InsertRequest[count];
        for (int i = 0; i < inserts.length; ++i) {
            Task task = new Task();
            task.setTitle("Task for folder count test " + (i + 1));
            task.setParentFolderID(folderId);
            task.setPrivateFlag(privat);
            inserts[i] = new InsertRequest(task, client.getValues().getTimeZone());
        }
        client.execute(MultipleRequest.create(inserts));
    }
}

