/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.contact.action.AbstractContactRequest;
import com.openexchange.ajax.contact.action.SearchParser;
import com.openexchange.ajax.contact.action.SearchResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.CommonSearchResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SearchByBirthdayRequest
extends AbstractContactRequest<CommonSearchResponse> {
    private final List<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
    private final SearchParser searchParser;

    public SearchByBirthdayRequest(Date start, Date end, String inFolder, int[] columns, boolean failOnError) {
        this(start, end, inFolder, columns, -1, null, null, failOnError);
    }

    public SearchByBirthdayRequest(Date start, Date end, String inFolder, int[] columns, int orderBy, String orderDir, String collation, boolean failOnError) {
        this.searchParser = new SearchParser(failOnError, columns);
        this.params.add(new AJAXRequest.Parameter("action", "birthdays"));
        this.params.add(new AJAXRequest.Parameter("start", String.valueOf(start.getTime())));
        this.params.add(new AJAXRequest.Parameter("end", String.valueOf(end.getTime())));
        if (null != columns) {
            this.params.add(new AJAXRequest.Parameter("columns", SearchByBirthdayRequest.getColumns(columns)));
        }
        if (-1 != orderBy) {
            this.params.add(new AJAXRequest.Parameter("sort", String.valueOf(orderBy)));
        }
        if (null != orderDir) {
            this.params.add(new AJAXRequest.Parameter("order", orderDir));
        }
        if (null != collation) {
            this.params.add(new AJAXRequest.Parameter("collation", collation));
        }
        if (null != inFolder) {
            this.params.add(new AJAXRequest.Parameter("folder", inFolder));
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return this.params.toArray(new AJAXRequest.Parameter[this.params.size()]);
    }

    @Override
    public AbstractAJAXParser<SearchResponse> getParser() {
        return this.searchParser;
    }

    @Override
    public Object getBody() {
        return null;
    }

    private static String getColumns(int[] values) {
        StringBuilder b = new StringBuilder();
        for (int v : values) {
            b.append(v).append(",");
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }
}

