/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AttachmentTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.parser.AppointmentParser;
import com.openexchange.ajax.writer.AppointmentWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.java.Charsets;
import com.openexchange.test.TestException;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class Bug16249Test
extends AttachmentTest {
    private int folderId;
    private TimeZone timeZone;
    private int appointmentId;
    private static final String APPOINTMENT_URL = "/ajax/calendar";

    public Bug16249Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folderId = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId()).getObjectID();
        this.timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
    }

    public void testBug16249() throws Exception {
        Appointment a = new Appointment();
        a.setTitle("Bug 16249 Test");
        a.setStartDate(TimeTools.D("01.07.2010 08:00"));
        a.setEndDate(TimeTools.D("01.07.2010 09:00"));
        a.setParentFolderID(this.folderId);
        a.setIgnoreConflicts(true);
        this.appointmentId = this.insertAppointment(this.getWebConversation(), a, this.timeZone, this.getHostName(), this.getSessionId());
        Date beforeAttach = this.loadAppointment(this.getWebConversation(), this.appointmentId, this.folderId, this.timeZone, this.getHostName(), this.getSessionId()).getLastModified();
        Response res = this.attach(this.getWebConversation(), this.getSessionId(), this.folderId, this.appointmentId, 1, this.testFile);
        int attachmentId = ((JSONArray)res.getData()).getInt(0);
        Date afterAttach = this.loadAppointment(this.getWebConversation(), this.appointmentId, this.folderId, this.timeZone, this.getHostName(), this.getSessionId()).getLastModified();
        this.detach(this.getWebConversation(), this.getSessionId(), this.folderId, this.appointmentId, 1, new int[]{attachmentId});
        Date afterDetach = this.loadAppointment(this.getWebConversation(), this.appointmentId, this.folderId, this.timeZone, this.getHostName(), this.getSessionId()).getLastModified();
        Bug16249Test.assertTrue((String)"Wrong last modified after attach", (beforeAttach.compareTo(afterAttach) < 0 ? 1 : 0) != 0);
        Bug16249Test.assertTrue((String)"Wrong last modified after detach", (beforeAttach.compareTo(afterDetach) < 0 ? 1 : 0) != 0);
        Bug16249Test.assertTrue((String)"Wrong last modified after detach", (afterAttach.compareTo(afterDetach) < 0 ? 1 : 0) != 0);
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteAppointment(this.getWebConversation(), this.appointmentId, this.folderId, this.getHostName(), this.getSessionId());
        super.tearDown();
    }

    public int insertAppointment(WebConversation webCon, Appointment appointmentObj, TimeZone userTimeZone, String host, String session) throws OXException, Exception, OXException {
        host = Bug16249Test.appendPrefix(host);
        int objectId = 0;
        StringWriter stringWriter = new StringWriter();
        JSONObject jsonObj = new JSONObject();
        AppointmentWriter appointmentwriter = new AppointmentWriter(userTimeZone);
        appointmentwriter.writeAppointment(appointmentObj, jsonObj);
        stringWriter.write(jsonObj.toString());
        stringWriter.flush();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "new");
        ByteArrayInputStream bais = new ByteArrayInputStream(stringWriter.toString().getBytes(Charsets.UTF_8));
        PutMethodWebRequest req = new PutMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        Bug16249Test.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            throw new TestException("json error: " + response.getErrorMessage());
        }
        JSONObject data = (JSONObject)response.getData();
        if (data.has("id")) {
            objectId = data.getInt("id");
        }
        if (data.has("conflicts")) {
            throw OXException.general((String)"conflicts found!");
        }
        return objectId;
    }

    public Appointment loadAppointment(WebConversation webCon, int objectId, int inFolder, TimeZone userTimeZone, String host, String session) throws Exception {
        host = Bug16249Test.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "get");
        parameter.setParameter("id", objectId);
        parameter.setParameter("folder", inFolder);
        GetMethodWebRequest req = new GetMethodWebRequest(host + APPOINTMENT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        Bug16249Test.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            Bug16249Test.fail((String)("json error: " + response.getErrorMessage()));
        }
        Bug16249Test.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        Appointment appointmentObj = new Appointment();
        AppointmentParser appointmentParser = new AppointmentParser(true, userTimeZone);
        appointmentParser.parse(appointmentObj, (JSONObject)response.getData());
        return appointmentObj;
    }

    public void deleteAppointment(WebConversation webCon, int id, int inFolder, String host, String session) throws Exception, OXException, IOException, SAXException {
        host = Bug16249Test.appendPrefix(host);
        AJAXSession ajaxSession = new AJAXSession(webCon, host, session);
        DeleteRequest deleteRequest = new DeleteRequest(id, inFolder, 0, new Date(Long.MAX_VALUE));
        deleteRequest.setFailOnError(false);
        CommonDeleteResponse response = Executor.execute(ajaxSession, deleteRequest);
        if (response.hasError()) {
            throw new Exception("json error: " + response.getResponse().getErrorMessage());
        }
    }
}

