/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.ajax.user.UserImpl4Test;
import com.openexchange.ajax.user.UserTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class UserTest
extends AbstractAJAXTest {
    public static final int[] CONTACT_FIELDS = new int[]{1, 524, 555, 501, 502, 500};
    private static final String USER_URL = "/ajax/contacts";

    public UserTest(String name) {
        super(name);
    }

    public void testSearch() throws Exception {
        UserImpl4Test[] users = UserTools.searchUser(this.getWebConversation(), this.getHostName(), "*", this.getSessionId());
        UserTest.assertTrue((String)"user array size > 0", (users.length > 0 ? 1 : 0) != 0);
    }

    public void testList() throws Exception {
        UserImpl4Test[] users = UserTools.searchUser(this.getWebConversation(), this.getHostName(), "*", this.getSessionId());
        UserTest.assertTrue((String)"user array size > 0", (users.length > 0 ? 1 : 0) != 0);
        int[] id = new int[users.length];
        for (int a = 0; a < id.length; ++a) {
            id[a] = users[a].getId();
        }
        users = UserTest.listUser(this.getWebConversation(), id, "http://" + this.getHostName(), this.getSessionId());
        UserTest.assertTrue((String)"user array size > 0", (users.length > 0 ? 1 : 0) != 0);
    }

    public void testSearchUsers() throws Exception {
        UserImpl4Test[] users = UserTools.searchUser(this.getWebConversation(), this.getHostName(), "*", this.getSessionId());
        UserTest.assertTrue((String)"user array size > 0", (users.length > 0 ? 1 : 0) != 0);
    }

    public void testGet() throws Exception {
        UserImpl4Test[] users = UserTools.searchUser(this.getWebConversation(), this.getHostName(), "*", this.getSessionId());
        UserTest.assertTrue((String)"user array size > 0", (users.length > 0 ? 1 : 0) != 0);
        UserTest.loadUser(this.getWebConversation(), users[0].getId(), this.getHostName(), this.getSessionId());
    }

    public static UserImpl4Test[] listUser(WebConversation webCon, int[] id, String host, String session) throws Exception {
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "list");
        StringBuffer stringBuffer = new StringBuffer();
        for (int a = 0; a < CONTACT_FIELDS.length; ++a) {
            if (a > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CONTACT_FIELDS[a]);
        }
        parameter.setParameter("columns", stringBuffer.toString());
        JSONArray requestArray = new JSONArray();
        for (int a = 0; a < id.length; ++a) {
            JSONObject jData = new JSONObject();
            jData.put("id", id[a]);
            jData.put("folder", 6);
            requestArray.put((Object)jData);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(requestArray.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest(host + USER_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        UserTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = ResponseParser.parse((String)resp.getText());
        if (response.hasError()) {
            UserTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        UserTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        JSONArray jsonArray = (JSONArray)response.getData();
        UserImpl4Test[] user = new UserImpl4Test[jsonArray.length()];
        for (int a = 0; a < user.length; ++a) {
            JSONArray jsonContactArray = jsonArray.getJSONArray(a);
            user[a] = new UserImpl4Test();
            user[a].setId(jsonContactArray.getInt(1));
            user[a].setMail(jsonContactArray.getString(2));
        }
        return user;
    }

    public static User loadUser(WebConversation webCon, int userId, String host, String session) throws OXException, IOException, SAXException, JSONException {
        return UserTools.getUser(webCon, host, session, userId);
    }
}

