/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.mapping;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.mappings.json.ArrayMapping;
import com.openexchange.groupware.tools.mappings.json.DefaultJsonMapper;
import com.openexchange.groupware.tools.mappings.json.DefaultJsonMapping;
import com.openexchange.groupware.tools.mappings.json.IntegerMapping;
import com.openexchange.groupware.tools.mappings.json.JsonMapping;
import com.openexchange.groupware.tools.mappings.json.StringMapping;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.session.Session;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.parser.ParsedUser;
import java.util.EnumMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserMapper
extends DefaultJsonMapper<User, UserField> {
    private static final UserMapper INSTANCE = new UserMapper();
    private UserField[] allFields = null;
    private static final Pattern identifierPattern = Pattern.compile("(\\p{Lower}{2})(?:[_-]([a-zA-Z]{2}))?(?:[_-]([a-zA-Z]{2}))?");
    private static final String DUMMY_DOMAIN = "@unspecified-domain";

    public static UserMapper getInstance() {
        return INSTANCE;
    }

    private UserMapper() {
    }

    public User newInstance() {
        return new ParsedUser();
    }

    public UserField[] newArray(int size) {
        return new UserField[size];
    }

    public JsonMapping<? extends Object, User> get(UserField field) throws OXException {
        if (null == field) {
            throw new IllegalArgumentException("field");
        }
        JsonMapping mapping = (JsonMapping)this.getMappings().get((Object)field);
        if (null == mapping) {
            throw OXException.notFound((String)field.toString());
        }
        return mapping;
    }

    public UserField[] getAllFields() {
        if (null == this.allFields) {
            this.allFields = this.mappings.keySet().toArray(this.newArray(this.mappings.keySet().size()));
        }
        return this.allFields;
    }

    protected EnumMap<UserField, JsonMapping<? extends Object, User>> createMappings() {
        EnumMap<UserField, JsonMapping<? extends Object, User>> mappings = new EnumMap<UserField, JsonMapping<? extends Object, User>>(UserField.class);
        mappings.put(UserField.ID, (JsonMapping<? extends Object, User>)new IntegerMapping<User>("id", 1){

            public boolean isSet(User object) {
                return -1 != object.getId();
            }

            public void set(User object, Integer value) throws OXException {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setId(null != value ? value : -1);
            }

            public Integer get(User object) {
                return object.getId();
            }

            public void remove(User object) {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setId(-1);
            }
        });
        mappings.put(UserField.ALIASES, (JsonMapping<? extends Object, User>)new ArrayMapping<String, User>("aliases", 610){

            public boolean isSet(User object) {
                return null != object.getAliases();
            }

            public void set(User object, String[] value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public String[] get(User object) {
                String[] aliases = object.getAliases();
                if (null == aliases || 0 == aliases.length) {
                    return aliases;
                }
                int length = aliases.length;
                String[] ret = new String[length];
                for (int i = 0; i < length; ++i) {
                    ret[i] = UserMapper.addr2String(aliases[i]);
                }
                return ret;
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }

            public String[] newArray(int size) {
                return new String[size];
            }

            protected String deserialize(JSONArray array, int index) throws JSONException, OXException {
                throw new UnsupportedOperationException();
            }
        });
        mappings.put(UserField.TIME_ZONE, (JsonMapping<? extends Object, User>)new StringMapping<User>("timezone", 611){

            public boolean isSet(User object) {
                return null != object.getTimeZone();
            }

            public void set(User object, String value) throws OXException {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setTimeZone(value);
            }

            public String get(User object) {
                return object.getTimeZone();
            }

            public void remove(User object) {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setTimeZone(null);
            }
        });
        mappings.put(UserField.LOCALE, (JsonMapping<? extends Object, User>)new DefaultJsonMapping<Locale, User>("locale", 612){

            public void deserialize(JSONObject from, User to) throws JSONException, OXException {
                if (from.hasAndNotNull(this.getAjaxName())) {
                    if (!ParsedUser.class.isInstance(to)) {
                        throw new UnsupportedOperationException();
                    }
                    ((ParsedUser)to).setLocale(UserMapper.parseLocaleString(from.getString(this.getAjaxName())));
                }
            }

            public boolean isSet(User object) {
                return null != object.getLocale();
            }

            public void set(User object, Locale value) throws OXException {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setLocale(value);
            }

            public Locale get(User object) {
                return object.getLocale();
            }

            public void remove(User object) {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setLocale(null);
            }
        });
        mappings.put(UserField.GROUPS, (JsonMapping<? extends Object, User>)new DefaultJsonMapping<int[], User>("groups", 613){

            public void deserialize(JSONObject from, User to) throws JSONException, OXException {
                throw new UnsupportedOperationException();
            }

            public Object serialize(User from, TimeZone timeZone, Session session) throws JSONException {
                int[] value = this.get(from);
                if (null == value) {
                    return JSONObject.NULL;
                }
                JSONArray jsonArray = new JSONArray(value.length);
                for (int group : value) {
                    jsonArray.put(group);
                }
                return jsonArray;
            }

            public boolean isSet(User object) {
                return null != object.getGroups();
            }

            public void set(User object, int[] value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public int[] get(User object) {
                return object.getGroups();
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }
        });
        mappings.put(UserField.CONTACT_ID, (JsonMapping<? extends Object, User>)new IntegerMapping<User>("contact_id", 614){

            public boolean isSet(User object) {
                return -1 != object.getContactId();
            }

            public void set(User object, Integer value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public Integer get(User object) {
                return object.getContactId();
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }
        });
        mappings.put(UserField.LOGIN_INFO, (JsonMapping<? extends Object, User>)new StringMapping<User>("login_info", 615){

            public boolean isSet(User object) {
                return null != object.getLoginInfo();
            }

            public void set(User object, String value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public String get(User object) {
                return object.getLoginInfo();
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }
        });
        return mappings;
    }

    static Locale parseLocaleString(String localeStr) throws OXException {
        if (null == localeStr) {
            return null;
        }
        Matcher match = identifierPattern.matcher(localeStr);
        Locale retval = null;
        if (match.matches()) {
            String country = match.group(2);
            String variant = match.group(3);
            retval = new Locale(UserMapper.toLowerCase(match.group(1)), country == null ? "" : UserMapper.toUpperCase(country), variant == null ? "" : variant);
        }
        return retval;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    static String addr2String(String primaryAddress) {
        if (null == primaryAddress) {
            return primaryAddress;
        }
        try {
            int pos;
            QuotedInternetAddress addr = new QuotedInternetAddress(primaryAddress);
            String sAddress = addr.getAddress();
            int n = pos = null == sAddress ? 0 : sAddress.indexOf(47);
            if (pos <= 0) {
                return addr.toUnicodeString();
            }
            StringAllocator sb = new StringAllocator(32);
            String personal = addr.getPersonal();
            if (null == personal) {
                sb.append(UserMapper.prepareAddress(sAddress.substring(0, pos)));
            } else {
                sb.append(UserMapper.preparePersonal(personal));
                sb.append(" <").append(UserMapper.prepareAddress(sAddress.substring(0, pos))).append('>');
            }
            return sb.toString();
        }
        catch (Exception e) {
            return primaryAddress;
        }
    }

    static String preparePersonal(String personal) {
        return MimeMessageUtility.quotePhrase((String)personal, (boolean)false);
    }

    static String prepareAddress(String address) {
        String decoded = QuotedInternetAddress.toIDN((String)MimeMessageUtility.decodeMultiEncodedHeader((String)address));
        int pos = decoded.indexOf(DUMMY_DOMAIN);
        if (pos >= 0) {
            return decoded.substring(0, pos);
        }
        return decoded;
    }
}

