/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class WebdavPath
implements Iterable<String> {
    private final List<String> components = new ArrayList<String>();

    public WebdavPath(CharSequence path) {
        StringBuilder component = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (component.length() > 0) {
                    this.components.add(component.toString());
                }
                component.setLength(0);
                continue;
            }
            component.append(c);
        }
        if (component.length() > 0) {
            this.components.add(component.toString());
        }
    }

    public WebdavPath(String ... components) {
        this.append(components);
    }

    public WebdavPath(Collection<String> components) {
        this.append(components);
    }

    @Override
    public Iterator<String> iterator() {
        return this.components.iterator();
    }

    public int size() {
        return this.components.size();
    }

    public WebdavPath append(String ... components) {
        return this.append(Arrays.asList(components));
    }

    public WebdavPath append(Collection<String> strings) {
        this.components.addAll(strings);
        return this;
    }

    public WebdavPath append(WebdavPath webdavPath) {
        return this.append(webdavPath.components);
    }

    public WebdavPath parent() {
        if (this.components.size() < 2) {
            return new WebdavPath(new String[0]);
        }
        return new WebdavPath(this.components.subList(0, this.components.size() - 1));
    }

    public String name() {
        if (this.components.size() == 0) {
            return "";
        }
        return this.components.get(this.components.size() - 1);
    }

    public WebdavPath dup() {
        return new WebdavPath(this.components);
    }

    public WebdavPath subpath(int from) {
        return this.subpath(from, this.size());
    }

    public WebdavPath subpath(int from, int to) {
        return new WebdavPath(this.components.subList(from, to));
    }

    public boolean equals(Object other) {
        if (!(other instanceof WebdavPath)) {
            return false;
        }
        return ((Object)this.components).equals(((WebdavPath)other).components);
    }

    public boolean startsWith(WebdavPath path) {
        if (path.size() > this.size()) {
            return false;
        }
        for (int i = 0; i < path.size(); ++i) {
            if (this.components.get(i).equals(path.components.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.components).hashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("/");
        for (String component : this.components) {
            b.append(component).append('/');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    public String toEscapedString() {
        StringBuilder b = new StringBuilder("/");
        for (String component : this.components) {
            b.append(this._escape(component)).append('/');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    private String _escape(String component) {
        if (component.indexOf(47) < 0 && component.indexOf(92) < 0) {
            return component;
        }
        return component.replaceAll("\\\\", "\\\\\\\\").replaceAll("/", "\\\\/");
    }
}

