/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.ifheader;

import com.openexchange.webdav.action.ifheader.IfHeader;
import com.openexchange.webdav.action.ifheader.IfHeaderEntity;
import com.openexchange.webdav.action.ifheader.IfHeaderList;
import com.openexchange.webdav.action.ifheader.IfHeaderParseException;
import java.util.ArrayList;

public class IfHeaderParser {
    private int i;

    public IfHeader parse(String string) throws IfHeaderParseException {
        this.i = 0;
        return this.ifHeader(string);
    }

    private IfHeader ifHeader(String cs) throws IfHeaderParseException {
        IfHeader ifHeader = new IfHeader();
        String tag = null;
        int length = cs.length();
        block5: while (this.i < length) {
            char c = cs.charAt(this.i++);
            switch (c) {
                case '(': {
                    ifHeader.addList(this.list(tag, cs));
                    tag = null;
                    continue block5;
                }
                case '<': {
                    tag = this.tag(cs);
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
            }
            throw new IfHeaderParseException("Illegal Character " + c + " for ifHeader", this.i + 1);
        }
        return ifHeader;
    }

    private String tag(String cs) throws IfHeaderParseException {
        StringBuffer tag = new StringBuffer();
        int start = this.i;
        int length = cs.length();
        block4: while (this.i < length) {
            char c = cs.charAt(this.i++);
            switch (c) {
                case '>': {
                    return tag.toString();
                }
                case ' ': {
                    continue block4;
                }
            }
            tag.append(c);
        }
        throw new IfHeaderParseException("Unfinished Tag", start + 1);
    }

    private IfHeaderList list(String tag, String cs) throws IfHeaderParseException {
        ArrayList<IfHeaderEntity> list = new ArrayList<IfHeaderEntity>();
        boolean matches = true;
        int start = this.i;
        int length = cs.length();
        block7: while (this.i < length) {
            char c = cs.charAt(this.i++);
            switch (c) {
                case '<': {
                    list.add(this.lockToken(matches, cs));
                    matches = true;
                    continue block7;
                }
                case '[': {
                    list.add(this.etag(matches, cs));
                    matches = true;
                    continue block7;
                }
                case ')': {
                    return new IfHeaderList(tag, list);
                }
                case 'N': 
                case 'n': {
                    this.not(cs);
                    matches = false;
                    continue block7;
                }
                case ' ': {
                    continue block7;
                }
            }
            throw new IfHeaderParseException("Illegal character " + c + " in list", this.i + 1);
        }
        throw new IfHeaderParseException("Unfinished List", start + 1);
    }

    private void not(String cs) throws IfHeaderParseException {
        char c;
        if ((c = cs.charAt(this.i++)) != 'o' && c != 'O') {
            throw new IfHeaderParseException("Illegal character " + c + " in list", this.i + 1);
        }
        if ((c = cs.charAt(this.i++)) != 't' && c != 'T') {
            throw new IfHeaderParseException("Illegal character " + c + " in list", this.i + 1);
        }
    }

    private IfHeaderEntity lockToken(boolean matches, String cs) throws IfHeaderParseException {
        try {
            IfHeaderEntity.LockToken entity = new IfHeaderEntity.LockToken(this.tag(cs));
            entity.setMatches(matches);
            return entity;
        }
        catch (IfHeaderParseException x) {
            throw new IfHeaderParseException("Unfinished LockToken", x.getColumn());
        }
    }

    private IfHeaderEntity etag(boolean matches, String cs) throws IfHeaderParseException {
        StringBuilder etag = new StringBuilder();
        int start = this.i;
        int length = cs.length();
        block4: while (this.i < length) {
            char c = cs.charAt(this.i++);
            switch (c) {
                case ']': {
                    IfHeaderEntity.ETag entity = new IfHeaderEntity.ETag(etag.toString());
                    entity.setMatches(matches);
                    return entity;
                }
                case ' ': {
                    continue block4;
                }
            }
            etag.append(c);
        }
        throw new IfHeaderParseException("Unfinished ETag", start + 1);
    }
}

