/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.log.LogFactory;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.xml.resources.PropertiesMarshaller;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;

public class WebdavLockAction
extends AbstractAction {
    private static final Namespace DAV_NS = Namespace.getNamespace((String)"DAV:");
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(WebdavLockAction.class));

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        WebdavLock lock = new WebdavLock();
        lock.setTimeout(this.getTimeout(req.getHeader("Timeout")));
        lock.setDepth(this.getDepth(req.getHeader("Depth")));
        try {
            List mentionedLocks;
            if (req.hasBody()) {
                this.configureLock(req, lock);
            } else {
                this.defaultLockParams(lock);
            }
            if (null == lock.getToken() && req.getUserInfo().containsKey("mentionedLocks") && 1 == (mentionedLocks = (List)req.getUserInfo().get("mentionedLocks")).size()) {
                lock.setToken((String)mentionedLocks.get(0));
            }
            WebdavResource resource = req.getResource();
            if (null != lock.getToken()) {
                WebdavLock originalLock = resource.getLock(lock.getToken());
                this.copyOldValues(originalLock, lock);
            }
            int status = 200;
            resource.lock(lock);
            resource = req.getFactory().resolveResource(req.getUrl());
            res.setStatus(200);
            res.setHeader("Lock-Token", lock.getToken());
            res.setHeader("content-type", "application/xml");
            WebdavProperty lockdiscovery = resource.getProperty("DAV:", "lockdiscovery");
            Element lockDiscoveryElement = new PropertiesMarshaller(req.getCharset()).marshalProperty(lockdiscovery, resource.getProtocol());
            Document responseDoc = new Document();
            Element rootElement = new Element("prop", DAV_NS);
            rootElement.addContent((Content)lockDiscoveryElement);
            responseDoc.setContent((Content)rootElement);
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(responseDoc, res.getOutputStream());
        }
        catch (JDOMException e) {
            LOG.error((Object)"JDOM Exception", (Throwable)e);
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 500);
        }
        catch (IOException e) {
            LOG.debug((Object)"Client gone?", (Throwable)e);
        }
    }

    private void copyOldValues(WebdavLock originalLock, WebdavLock lock) {
        if (lock.getOwner() == null) {
            lock.setOwner(originalLock.getOwner());
        }
    }

    private void defaultLockParams(WebdavLock lock) {
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
    }

    private void configureLock(WebdavRequest req, WebdavLock lock) throws JDOMException, IOException {
        Element root = req.getBodyAsDocument().getRootElement();
        Element lockscope = (Element)root.getChild("lockscope", DAV_NS).getChildren().get(0);
        if (lockscope.getNamespace().equals((Object)DAV_NS)) {
            if (lockscope.getName().equalsIgnoreCase("shared")) {
                lock.setScope(WebdavLock.Scope.SHARED_LITERAL);
            } else {
                lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
            }
        }
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        Element owner = root.getChild("owner", DAV_NS);
        XMLOutputter outputter = new XMLOutputter();
        if (owner != null) {
            lock.setOwner(outputter.outputString(owner.cloneContent()));
        }
    }

    private int getDepth(String header) {
        if (null == header) {
            return 0;
        }
        if (header.equalsIgnoreCase("infinity")) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    private long getTimeout(String header) {
        if (null == header) {
            return 600000L;
        }
        if (header.indexOf(44) != -1) {
            header = header.substring(0, header.indexOf(44)).trim();
        }
        if (header.equalsIgnoreCase("infinite")) {
            return -1L;
        }
        return Long.parseLong(header.substring(7)) * 1000L;
    }
}

