/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.java.Charsets;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.ParameterValue;
import com.openexchange.tools.versit.ParameterValueDefinition;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.old.OldBase64Encoding;
import com.openexchange.tools.versit.old.OldEncoding;
import com.openexchange.tools.versit.old.OldFoldingWriter;
import com.openexchange.tools.versit.old.OldParamDefinition;
import com.openexchange.tools.versit.old.OldQuotedPrintable;
import com.openexchange.tools.versit.old.OldScanner;
import com.openexchange.tools.versit.old.OldXBitEncoding;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;

public class OldPropertyDefinition {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(OldPropertyDefinition.class));
    private final Map<String, OldParamDefinition> Params = new HashMap<String, OldParamDefinition>();
    private final Map<Object, String> ParamValues = new HashMap<Object, String>();

    public OldPropertyDefinition(String[] paramNames, OldParamDefinition[] params) {
        HashSet<String> duplicates = new HashSet<String>();
        for (int i = 0; i < paramNames.length; ++i) {
            this.Params.put(paramNames[i], params[i]);
            int size = params[i].size();
            Iterator<String> j = params[i].getValues();
            for (int k = 0; k < size; ++k) {
                String value = j.next();
                if (this.ParamValues.containsKey(value)) {
                    this.ParamValues.remove(value);
                    duplicates.add(value);
                    continue;
                }
                if (duplicates.contains(value)) continue;
                this.ParamValues.put(value, paramNames[i]);
            }
        }
    }

    public void parse(OldScanner s, String name, VersitObject object) throws IOException {
        Property property = new Property(name);
        this.parse(s, property);
        object.addProperty(property);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(OldScanner s, Property property) throws IOException {
        OldEncoding encoding;
        s.skipWS();
        boolean uri = false;
        while (s.peek == 59) {
            Parameter parameter;
            s.read();
            s.skipWS();
            String param = s.parseWord().toUpperCase();
            s.skipWS();
            if (s.peek == 61) {
                s.read();
                s.skipWS();
                OldParamDefinition paramdef = this.Params.get(param);
                if (paramdef == null) {
                    paramdef = OldParamDefinition.Default;
                }
                parameter = new Parameter(param);
                uri = "URI".equals(param);
                paramdef.parse(s, parameter, uri);
                property.addParameter(parameter);
                while (s.peek == 44) {
                    s.read();
                    ParameterValue parameterValue = ParameterValueDefinition.Default.parse(s);
                    if (parameterValue == null) continue;
                    parameter.addValue(parameterValue);
                }
            } else {
                String paramname = this.ParamValues.get(param);
                if (paramname != null) {
                    parameter = new Parameter(paramname);
                    parameter.addValue(new ParameterValue(param));
                    property.addParameter(parameter);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unknown property parameter: " + param));
                }
            }
            s.skipWS();
        }
        if (s.peek != 58) {
            if (!uri) throw new VersitException(s, "':' expected");
            property.setValue("");
            return;
        }
        s.read();
        Parameter param = property.getParameter("ENCODING");
        if (param != null) {
            String encoding_str = param.getValue(0).getText();
            if ("QUOTED-PRINTABLE".equalsIgnoreCase(encoding_str)) {
                encoding = OldQuotedPrintable.Default;
            } else if ("BASE64".equalsIgnoreCase(encoding_str)) {
                encoding = OldBase64Encoding.Default;
            } else if ("8BIT".equalsIgnoreCase(encoding_str)) {
                encoding = OldXBitEncoding.Default;
            } else {
                if (!"7BIT".equalsIgnoreCase(encoding_str)) throw new VersitException(s, "Unknown encoding: " + encoding_str);
                encoding = OldXBitEncoding.Default;
            }
        } else {
            encoding = s.DefaultEncoding;
        }
        String charset = (param = property.getParameter("CHARSET")) == null ? s.DefaultCharset : param.getValue(0).getText();
        try {
            property.setValue(this.parseValue(property, s, encoding.decode(s), MimeUtility.javaCharset((String)charset)));
            return;
        }
        catch (UnsupportedEncodingException e) {
            VersitException ve = new VersitException(s, "Unsupported charset");
            ve.initCause(e);
            throw ve;
        }
    }

    protected Object parseValue(Property property, OldScanner s, byte[] value, String charset) throws IOException {
        return new String(value, Charsets.forName((String)charset)).replaceAll("\\\\(.)", "$1");
    }

    protected void writeType(OldFoldingWriter fw, Property property) throws IOException {
        fw.write(property.name);
        Parameter type = property.getParameter("TYPE");
        if (type != null) {
            for (int i = 0; i < type.getValueCount(); ++i) {
                fw.write(";");
                String val = type.getValue(i).getText();
                if (!this.ParamValues.containsKey(val)) {
                    fw.write("TYPE");
                    fw.write("=");
                }
                fw.write(val);
            }
        }
    }

    public void write(OldFoldingWriter fw, Property property) throws IOException {
        this.writeType(fw, property);
        String value = this.writeValue(property).replaceAll("([^\\r])\\n", "$1\\r\\n");
        if (value.length() > 0 && value.charAt(0) == '\n') {
            value = "\r" + value;
        }
        OldEncoding encoding = OldXBitEncoding.Default;
        if (value.length() <= 74 - fw.lineLength()) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if ((c == '\t' || c >= ' ') && c <= '~') continue;
                encoding = OldQuotedPrintable.Default;
                fw.write(";");
                fw.write("QUOTED-PRINTABLE");
                break;
            }
        } else {
            encoding = OldQuotedPrintable.Default;
            fw.write(";");
            fw.write("QUOTED-PRINTABLE");
        }
        String charset = fw.charset;
        if (!fw.encoder.canEncode(value)) {
            fw.write(";");
            fw.write("CHARSET");
            fw.write("=");
            fw.write("UTF-8");
            charset = "UTF8";
        }
        fw.write(":");
        encoding.encode(fw, value.getBytes(charset));
    }

    protected String writeValue(Property property) {
        return property.getValue().toString().replaceAll("\\\\", "\\\\\\\\");
    }
}

