/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.session;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;

public class ServerSessionAdapter
implements ServerSession,
PutIfAbsent {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ServerSessionAdapter.class));
    private final Session session;
    private final Context ctx;
    private volatile User user;
    private volatile UserConfiguration userConfiguration;
    private volatile UserSettingMail userSettingMail;
    private final ServerSession serverSession;

    public static ServerSession valueOf(Session session) throws OXException {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session);
    }

    public static ServerSession valueOf(Session session, Context context) {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session, context);
    }

    public static ServerSession valueOf(Session session, Context context, User user) {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session, context, user);
    }

    public static ServerSession valueOf(Session session, Context context, User user, UserConfiguration userConfiguration) {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session, context, user, userConfiguration);
    }

    public ServerSessionAdapter(Session session) throws OXException {
        if (null == session) {
            throw new OXException((Throwable)new IllegalArgumentException("Session is null."));
        }
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
            this.ctx = null;
        } else {
            this.serverSession = null;
            this.session = session;
            int contextId = session.getContextId();
            this.ctx = contextId > 0 ? ContextStorage.getStorageContext(contextId) : null;
        }
    }

    public ServerSessionAdapter(Session session, Context ctx) {
        if (null == session) {
            throw new IllegalArgumentException("Session is null.");
        }
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
            this.ctx = null;
        } else {
            this.serverSession = null;
            this.session = session;
            this.ctx = ctx;
        }
    }

    public ServerSessionAdapter(Session session, Context ctx, User user) {
        if (null == session) {
            throw new IllegalArgumentException("Session is null.");
        }
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
            this.ctx = null;
        } else {
            this.serverSession = null;
            this.session = session;
            this.ctx = ctx;
            this.user = user;
        }
    }

    public ServerSessionAdapter(Session session, Context ctx, User user, UserConfiguration userConfiguration) {
        if (null == session) {
            throw new IllegalArgumentException("Session is null.");
        }
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
            this.ctx = null;
        } else {
            this.serverSession = null;
            this.session = session;
            this.ctx = ctx;
            this.user = user;
            this.userConfiguration = userConfiguration;
        }
    }

    public int getContextId() {
        return this.session().getContextId();
    }

    public String getLocalIp() {
        return this.session().getLocalIp();
    }

    public void setLocalIp(String ip) {
        this.session().setLocalIp(ip);
    }

    public String getLoginName() {
        return this.session().getLoginName();
    }

    public boolean containsParameter(String name) {
        return this.session().containsParameter(name);
    }

    public Object getParameter(String name) {
        return this.session().getParameter(name);
    }

    public String getPassword() {
        return this.session().getPassword();
    }

    public String getRandomToken() {
        return this.session().getRandomToken();
    }

    public String getSecret() {
        return this.session().getSecret();
    }

    public String getSessionID() {
        return this.session().getSessionID();
    }

    public int getUserId() {
        return this.session().getUserId();
    }

    public String getUserlogin() {
        return this.session().getUserlogin();
    }

    public void setParameter(String name, Object value) {
        this.session().setParameter(name, value);
    }

    public Object setParameterIfAbsent(String name, Object value) {
        Session session = this.session();
        if (session instanceof PutIfAbsent) {
            return ((PutIfAbsent)session).setParameterIfAbsent(name, value);
        }
        Object prev = session.getParameter(name);
        if (null == prev) {
            session.setParameter(name, value);
            return null;
        }
        return prev;
    }

    public String getAuthId() {
        return this.session().getAuthId();
    }

    @Override
    public Context getContext() {
        if (this.serverSession != null) {
            return this.serverSession.getContext();
        }
        return this.ctx;
    }

    public String getLogin() {
        return this.session().getLogin();
    }

    public String getHash() {
        return this.session().getHash();
    }

    public String getClient() {
        return this.session.getClient();
    }

    public void setClient(String client) {
        this.session.setClient(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser() {
        if (this.serverSession != null) {
            return this.serverSession.getUser();
        }
        int userId = this.session.getUserId();
        if (userId <= 0) {
            return null;
        }
        User tmp = this.user;
        if (null == tmp) {
            ServerSessionAdapter serverSessionAdapter = this;
            synchronized (serverSessionAdapter) {
                tmp = this.user;
                if (null == tmp) {
                    this.user = tmp = UserStorage.getStorageUser(userId, this.ctx);
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserConfiguration getUserConfiguration() {
        if (this.serverSession != null) {
            return this.serverSession.getUserConfiguration();
        }
        int userId = this.session.getUserId();
        if (userId <= 0) {
            return null;
        }
        UserConfiguration tmp = this.userConfiguration;
        if (null == tmp) {
            ServerSessionAdapter serverSessionAdapter = this;
            synchronized (serverSessionAdapter) {
                tmp = this.userConfiguration;
                if (null == tmp) {
                    try {
                        tmp = userId > 0 ? UserConfigurationStorage.getInstance().getUserConfiguration(userId, this.ctx) : null;
                        this.userConfiguration = tmp;
                    }
                    catch (OXException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSettingMail getUserSettingMail() {
        if (this.serverSession != null) {
            return this.serverSession.getUserSettingMail();
        }
        int userId = this.session.getUserId();
        if (userId <= 0) {
            return null;
        }
        UserSettingMail tmp = this.userSettingMail;
        if (null == tmp) {
            ServerSessionAdapter serverSessionAdapter = this;
            synchronized (serverSessionAdapter) {
                tmp = this.userSettingMail;
                if (null == tmp) {
                    this.userSettingMail = tmp = UserSettingMailStorage.getInstance().getUserSettingMail(userId, this.ctx);
                }
            }
        }
        return tmp;
    }

    private Session session() {
        if (this.serverSession != null) {
            return this.serverSession;
        }
        return this.session;
    }

    public void setHash(String hash) {
        this.session().setHash(hash);
    }

    @Override
    public boolean isAnonymous() {
        return this.session.getUserId() <= 0;
    }

    public String toString() {
        return this.session.toString();
    }

    public boolean isTransient() {
        return this.session.isTransient();
    }
}

