/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.regex;

import com.openexchange.java.StringAllocator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MatcherReplacer {
    private Matcher matcher;
    private String input;
    private int lastPos;

    public MatcherReplacer() {
        this(Pattern.compile(".+").matcher(""), "");
    }

    public MatcherReplacer(Matcher matcher, String input) {
        if (null == matcher) {
            throw new IllegalArgumentException("matcher is null");
        }
        if (null == input) {
            throw new IllegalArgumentException("input is null");
        }
        this.matcher = matcher;
        this.input = input;
        this.lastPos = 0;
    }

    public void resetTo(Matcher matcher, String input) {
        if (null == matcher) {
            throw new IllegalArgumentException("matcher is null");
        }
        if (null == input) {
            throw new IllegalArgumentException("input is null");
        }
        this.matcher = matcher;
        this.input = input;
        this.lastPos = 0;
    }

    public void appendLiteralReplacement(StringBuilder sb, String replacement) {
        sb.append(this.input.substring(this.lastPos, this.matcher.start()));
        sb.append(replacement);
        this.lastPos = this.matcher.end();
    }

    public void appendLiteralReplacement(StringAllocator sb, String replacement) {
        sb.append(this.input.substring(this.lastPos, this.matcher.start()));
        sb.append(replacement);
        this.lastPos = this.matcher.end();
    }

    public void appendReplacement(StringBuilder sb, String replacement) {
        sb.append(this.input.substring(this.lastPos, this.matcher.start()));
        int cursor = 0;
        int rlen = replacement.length();
        while (cursor < rlen) {
            char nextChar = replacement.charAt(cursor);
            if ('\\' == nextChar) {
                nextChar = replacement.charAt(++cursor);
                sb.append(nextChar);
                ++cursor;
                continue;
            }
            if ('$' == nextChar) {
                int nextDigit;
                int refNum;
                if ((refNum = replacement.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < rlen && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (this.matcher.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (this.matcher.group(refNum) == null) continue;
                sb.append(this.matcher.group(refNum));
                continue;
            }
            sb.append(nextChar);
            ++cursor;
        }
        this.lastPos = this.matcher.end();
    }

    public void appendReplacement(StringAllocator sb, String replacement) {
        sb.append(this.input.substring(this.lastPos, this.matcher.start()));
        int cursor = 0;
        int rlen = replacement.length();
        while (cursor < rlen) {
            char nextChar = replacement.charAt(cursor);
            if ('\\' == nextChar) {
                nextChar = replacement.charAt(++cursor);
                sb.append(nextChar);
                ++cursor;
                continue;
            }
            if ('$' == nextChar) {
                int nextDigit;
                int refNum;
                if ((refNum = replacement.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < rlen && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (this.matcher.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (this.matcher.group(refNum) == null) continue;
                sb.append(this.matcher.group(refNum));
                continue;
            }
            sb.append(nextChar);
            ++cursor;
        }
        this.lastPos = this.matcher.end();
    }

    public void appendTail(StringBuilder sb) {
        sb.append(this.input.substring(this.lastPos));
    }

    public void appendTail(StringAllocator sb) {
        sb.append(this.input.substring(this.lastPos));
    }
}

