/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.javacodegeeks.concurrent.ConcurrentLinkedHashMap;
import com.javacodegeeks.concurrent.EvictionPolicy;

public final class AgePolicy
implements EvictionPolicy {
    private final long ageThresholdMillis;

    public AgePolicy(long ageThresholdMillis) {
        this.ageThresholdMillis = ageThresholdMillis;
    }

    public boolean accessOrder() {
        return true;
    }

    public boolean insertionOrder() {
        return false;
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> evictElement(ConcurrentLinkedHashMap.Entry<?, ?> head) {
        return head.getAfter();
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> recordInsertion(ConcurrentLinkedHashMap.Entry<?, ?> head, ConcurrentLinkedHashMap.Entry<?, ?> insertedEntry) {
        return null;
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> recordAccess(ConcurrentLinkedHashMap.Entry<?, ?> head, ConcurrentLinkedHashMap.Entry<?, ?> accessedEntry) {
        long ageThresholdMillis = this.ageThresholdMillis;
        if (ageThresholdMillis <= 0L) {
            return head;
        }
        long accessedEntryAge = System.currentTimeMillis() - accessedEntry.getCreationTime();
        if (accessedEntryAge < ageThresholdMillis) {
            return head;
        }
        return accessedEntry.getAfter();
    }
}

