/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.folderstorage.cache.CacheServiceRegistry;
import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.internal.CachedResolveType;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class CachingMailAccountStorage
implements MailAccountStorageService {
    private static final String REGION_NAME = "MailAccount";
    private final RdbMailAccountStorage delegate;
    private final Lock cacheLock;
    private static volatile Integer maxWaitMillis;

    CachingMailAccountStorage(RdbMailAccountStorage delegate) {
        this.delegate = delegate;
        this.cacheLock = new ReentrantLock(true);
    }

    RdbMailAccountStorage getDelegate() {
        return this.delegate;
    }

    static CacheKey newCacheKey(CacheService cacheService, int id, int user, int cid) {
        return cacheService.newCacheKey(cid, new Serializable[]{Integer.valueOf(id), Integer.valueOf(user)});
    }

    @Override
    public void invalidateMailAccount(int id, int user, int cid) throws OXException {
        FolderMap folderMap;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            Cache cache = cacheService.getCache(REGION_NAME);
            cache.remove((Serializable)CachingMailAccountStorage.newCacheKey(cacheService, id, user, cid));
            cache.invalidateGroup(Integer.toString(cid));
        }
        if (null != (folderMap = FolderMapManagement.getInstance().optFor(user, cid))) {
            folderMap.remove("default" + id, FolderStorage.REAL_TREE_ID);
            folderMap.remove("default" + id, "1");
        }
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid, boolean deletePrimary, Connection con) throws OXException {
        this.delegate.deleteMailAccount(id, properties, user, cid, deletePrimary, con);
        this.invalidateMailAccount(id, user, cid);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid, boolean deletePrimary) throws OXException {
        this.delegate.deleteMailAccount(id, properties, user, cid, deletePrimary);
        this.invalidateMailAccount(id, user, cid);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid) throws OXException {
        this.delegate.deleteMailAccount(id, properties, user, cid);
        this.invalidateMailAccount(id, user, cid);
    }

    @Override
    public MailAccount getDefaultMailAccount(int user, int cid) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getDefaultMailAccount(user, cid);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)CachingMailAccountStorage.newCacheKey(cacheService, 0, user, cid));
        if (object instanceof MailAccount) {
            return (MailAccount)object;
        }
        MailAccount defaultMailAccount = this.delegate.getDefaultMailAccount(user, cid);
        cache.put((Serializable)CachingMailAccountStorage.newCacheKey(cacheService, 0, user, cid), (Serializable)defaultMailAccount, false);
        return defaultMailAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccount getMailAccount(int id, int user, int cid) throws OXException {
        CacheKey key;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getMailAccount(id, user, cid);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)(key = CachingMailAccountStorage.newCacheKey(cacheService, id, user, cid)));
        if (object instanceof MailAccount) {
            return (MailAccount)object;
        }
        RdbMailAccountStorage d = this.delegate;
        try {
            MailAccount mailAccount = d.getMailAccount(id, user, cid);
            cache.put((Serializable)key, (Serializable)mailAccount, false);
            return mailAccount;
        }
        catch (OXException e) {
            if (!MailAccountExceptionCodes.NOT_FOUND.equals(e)) {
                throw e;
            }
            Connection wcon = Database.get(cid, true);
            try {
                MailAccount mailAccount = d.getMailAccount(id, user, cid, wcon);
                cache.put((Serializable)key, (Serializable)mailAccount, false);
                MailAccount mailAccount2 = mailAccount;
                return mailAccount2;
            }
            finally {
                Database.back(cid, true, wcon);
            }
        }
    }

    @Override
    public int getByPrimaryAddress(String primaryAddress, int user, int cid) throws OXException {
        return this.delegate.getByPrimaryAddress(primaryAddress, user, cid);
    }

    @Override
    public int[] getByHostNames(Collection<String> hostNames, int user, int cid) throws OXException {
        return this.delegate.getByHostNames(hostNames, user, cid);
    }

    @Override
    public MailAccount[] getUserMailAccounts(int user, int cid, Connection con) throws OXException {
        int[] ids = this.delegate.getUserMailAccountIDs(user, cid, con);
        MailAccount[] accounts = new MailAccount[ids.length];
        for (int i = 0; i < accounts.length; ++i) {
            accounts[i] = this.getMailAccount0(ids[i], user, cid, con);
        }
        return accounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailAccount getMailAccount0(int id, int user, int cid, Connection con) throws OXException {
        Object object;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getMailAccount(id, user, cid);
        }
        CacheKey key = CachingMailAccountStorage.newCacheKey(cacheService, id, user, cid);
        Cache cache = cacheService.getCache(REGION_NAME);
        if (cache.get((Serializable)key) == null) {
            CachingMailAccountStorage.acquire(this.cacheLock);
            try {
                if (cache.get((Serializable)key) == null) {
                    MailAccount mailAccount = this.delegate.getMailAccount(id, user, cid, con);
                    cache.put((Serializable)key, (Serializable)mailAccount, false);
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        if ((object = cache.get((Serializable)key)) instanceof MailAccount) {
            return (MailAccount)object;
        }
        MailAccount mailAccount = this.delegate.getMailAccount(id, user, cid);
        cache.put((Serializable)key, (Serializable)mailAccount, false);
        return mailAccount;
    }

    @Override
    public MailAccount[] getUserMailAccounts(int user, int cid) throws OXException {
        int[] ids = this.delegate.getUserMailAccountIDs(user, cid);
        MailAccount[] accounts = new MailAccount[ids.length];
        for (int i = 0; i < accounts.length; ++i) {
            accounts[i] = this.getMailAccount(ids[i], user, cid);
        }
        return accounts;
    }

    @Override
    public MailAccount[] resolveLogin(String login, int cid) throws OXException {
        int[][] idsAndUsers = CachingMailAccountStorage.resolveFromCache(login, cid, new FromDelegate(){

            @Override
            public int[][] getFromDelegate(String pattern, int contextId) throws OXException {
                return CachingMailAccountStorage.this.getDelegate().resolveLogin2IDs(pattern, contextId);
            }
        }, CachedResolveType.LOGIN);
        MailAccount[] accounts = new MailAccount[idsAndUsers.length];
        for (int i = 0; i < accounts.length; ++i) {
            int[] idAndUser = idsAndUsers[i];
            accounts[i] = this.getMailAccount(idAndUser[0], idAndUser[1], cid);
        }
        return accounts;
    }

    @Override
    public MailAccount[] resolveLogin(String login, InetSocketAddress server, int cid) throws OXException {
        int[][] idsAndUsers = CachingMailAccountStorage.resolveFromCache(login, cid, new FromDelegate(){

            @Override
            public int[][] getFromDelegate(String pattern, int contextId) throws OXException {
                return CachingMailAccountStorage.this.getDelegate().resolveLogin2IDs(pattern, contextId);
            }
        }, CachedResolveType.LOGIN);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            MailAccount candidate = this.getMailAccount(idAndUser[0], idAndUser[1], cid);
            if (!server.equals(ProviderUtility.toSocketAddr(candidate.generateMailServerURL(), 143))) continue;
            l.add(candidate);
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int user, int cid, Session session) throws OXException {
        this.delegate.updateMailAccount(mailAccount, attributes, user, cid, session);
        this.invalidateMailAccount(mailAccount.getId(), user, cid);
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int user, int cid, Session session, Connection con, boolean changePrimary) throws OXException {
        this.delegate.updateMailAccount(mailAccount, attributes, user, cid, session, con, changePrimary);
        this.invalidateMailAccount(mailAccount.getId(), user, cid);
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, int user, int cid, Session session) throws OXException {
        this.delegate.updateMailAccount(mailAccount, user, cid, session);
        this.invalidateMailAccount(mailAccount.getId(), user, cid);
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int user, Context ctx, Session session) throws OXException {
        int id = this.delegate.insertMailAccount(mailAccount, user, ctx, session);
        this.invalidateMailAccount(id, user, ctx.getContextId());
        return id;
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int user, Context ctx, Session session, Connection con) throws OXException {
        int id = this.delegate.insertMailAccount(mailAccount, user, ctx, session, con);
        this.invalidateMailAccount(id, user, ctx.getContextId());
        return id;
    }

    @Override
    public MailAccount[] resolvePrimaryAddr(String primaryAddress, int cid) throws OXException {
        int[][] idsAndUsers = CachingMailAccountStorage.resolveFromCache(primaryAddress, cid, new FromDelegate(){

            @Override
            public int[][] getFromDelegate(String pattern, int contextId) throws OXException {
                return CachingMailAccountStorage.this.getDelegate().resolvePrimaryAddr2IDs(pattern, contextId);
            }
        }, CachedResolveType.PRIMARY_ADDRESS);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            l.add(this.getMailAccount(idAndUser[0], idAndUser[1], cid));
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    private static int[][] resolveFromCache(String pattern, int cid, FromDelegate delegate, CachedResolveType type) throws OXException {
        int[][] idsAndUsers;
        int[][] tmp;
        Cache cache;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return delegate.getFromDelegate(pattern, cid);
        }
        try {
            cache = cacheService.getCache(REGION_NAME);
        }
        catch (OXException e) {
            cache = null;
        }
        if (null == cache) {
            return delegate.getFromDelegate(pattern, cid);
        }
        CacheKey key = cacheService.newCacheKey(type.ordinal(), (Serializable)((Object)pattern));
        try {
            tmp = (int[][])cache.getFromGroup((Serializable)key, Integer.toString(cid));
        }
        catch (ClassCastException e) {
            tmp = null;
        }
        if (null == tmp) {
            idsAndUsers = delegate.getFromDelegate(pattern, cid);
            cache.putInGroup((Serializable)key, Integer.toString(cid), (Serializable)idsAndUsers, false);
        } else {
            idsAndUsers = tmp;
        }
        return idsAndUsers;
    }

    @Override
    public MailAccount getTransportAccountForID(int id, int user, int cid) throws OXException {
        MailAccount account = this.getMailAccount(id, user, cid);
        if (null == account.getTransportServer()) {
            return this.getDefaultMailAccount(user, cid);
        }
        return account;
    }

    @Override
    public void migratePasswords(int user, int cid, String oldSecret, String newSecret) throws OXException {
        int[] ids;
        this.delegate.migratePasswords(user, cid, oldSecret, newSecret);
        for (int id : ids = this.delegate.getUserMailAccountIDs(user, cid)) {
            this.invalidateMailAccount(id, user, cid);
        }
    }

    @Override
    public boolean hasAccounts(Session session) throws OXException {
        return this.delegate.hasAccounts(session);
    }

    @Override
    public void cleanUp(String secret, Session session) throws OXException {
        this.delegate.cleanUp(secret, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxWaitMillis() {
        Integer i = maxWaitMillis;
        if (null != i) return i;
        Class<CacheFolderStorage> clazz = CacheFolderStorage.class;
        synchronized (CacheFolderStorage.class) {
            i = maxWaitMillis;
            if (null != i) return i;
            ConfigurationService service = (ConfigurationService)CacheServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
            int millis = null == service ? 60000 : service.getIntProperty("AJP_WATCHER_MAX_RUNNING_TIME", 60000);
            maxWaitMillis = i = Integer.valueOf(millis << 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return i;
        }
    }

    private static void acquire(Lock lock) throws OXException {
        if (null == lock) {
            return;
        }
        try {
            if (!lock.tryLock(CachingMailAccountStorage.maxWaitMillis(), TimeUnit.MILLISECONDS)) {
                throw FolderExceptionErrorMessage.TRY_AGAIN.create("The maximum time to wait for the lock is exceeded.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw FolderExceptionErrorMessage.TRY_AGAIN.create(e, e.getMessage());
        }
    }

    private static interface FromDelegate {
        public int[][] getFromDelegate(String var1, int var2) throws OXException;
    }
}

