/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.crypto.CryptoService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.internal.GenericProperty;
import com.openexchange.secret.SecretEncryptionFactoryService;
import com.openexchange.secret.SecretEncryptionService;
import com.openexchange.secret.SecretEncryptionStrategy;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;

public final class MailPasswordUtil {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailPasswordUtil.class));
    private static final int KEY_LENGTH = 8;
    private static final String ALGORITHM_DES = "DES";
    private static final String CIPHER_TYPE = "DES/ECB/PKCS5Padding";
    public static final SecretEncryptionStrategy<GenericProperty> STRATEGY = new SecretEncryptionStrategy<GenericProperty>(){

        public void update(String recrypted, GenericProperty customizationNote) throws OXException {
            int contextId = customizationNote.session.getContextId();
            Connection con = Database.get(contextId, true);
            try {
                con.setAutoCommit(false);
                this.update0(recrypted, customizationNote, con);
                con.commit();
            }
            catch (SQLException e) {
                DBUtils.rollback(con);
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (RuntimeException e) {
                DBUtils.rollback(con);
                throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.autocommit(con);
                Database.back(contextId, true, con);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update0(String recrypted, GenericProperty customizationNote, Connection con) throws SQLException {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement("UPDATE user_mail_account SET password = ? WHERE cid = ? AND user = ? AND id = ?");
                Session session = customizationNote.session;
                stmt.setString(1, recrypted);
                stmt.setInt(2, session.getContextId());
                stmt.setInt(3, session.getUserId());
                stmt.setInt(4, customizationNote.accountId);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(stmt);
                stmt = con.prepareStatement("UPDATE user_transport_account SET password = ? WHERE cid = ? AND user = ? AND id = ? AND (password IS NOT NULL AND password <> '')");
                stmt.setString(1, recrypted);
                stmt.setInt(2, session.getContextId());
                stmt.setInt(3, session.getUserId());
                stmt.setInt(4, customizationNote.accountId);
                stmt.executeUpdate();
                MailAccountStorageService service = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
                if (null != service) {
                    try {
                        service.invalidateMailAccount(customizationNote.accountId, session.getUserId(), session.getContextId());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
    };

    public static String encrypt(String password, String key) throws GeneralSecurityException {
        return MailPasswordUtil.encrypt(password, MailPasswordUtil.generateSecretKey(key));
    }

    public static String decrypt(String encryptedPassword, Session session, int accountId, String login, String server) throws OXException {
        SecretEncryptionService encryptionService = ServerServiceRegistry.getInstance().getService(SecretEncryptionFactoryService.class).createService(STRATEGY);
        return encryptionService.decrypt(session, encryptedPassword, (Object)new GenericProperty(accountId, session, login, server));
    }

    public static String decrypt(String encryptedPassword, String key) throws GeneralSecurityException {
        try {
            return MailPasswordUtil.decrypt(encryptedPassword, MailPasswordUtil.generateSecretKey(key));
        }
        catch (GeneralSecurityException e) {
            CryptoService crypto = ServerServiceRegistry.getInstance().getService(CryptoService.class);
            if (null == crypto) {
                LOG.warn((Object)("MailPasswordUtil.decrypt(): Missing " + CryptoService.class.getSimpleName()));
                throw e;
            }
            try {
                return crypto.decrypt(encryptedPassword, key);
            }
            catch (OXException ce) {
                StringAllocator sb = new StringAllocator(128).append("MailPasswordUtil.decrypt(): Failed to decrypt \"");
                sb.append(encryptedPassword).append("\" with ").append(CryptoService.class.getSimpleName());
                LOG.debug((Object)sb.toString(), (Throwable)ce);
                throw e;
            }
        }
    }

    public static String encrypt(String password, Key key) throws GeneralSecurityException {
        if (null == password || null == key) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        cipher.init(1, key);
        byte[] outputBytes = cipher.doFinal(password.getBytes(Charsets.UTF_8));
        return Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])outputBytes));
    }

    public static String decrypt(String encryptedPassword, Key key) throws GeneralSecurityException {
        if (null == encryptedPassword || null == key) {
            return null;
        }
        byte[] encrypted = Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)encryptedPassword));
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        cipher.init(2, key);
        byte[] outputBytes = cipher.doFinal(encrypted);
        return new String(outputBytes, Charsets.UTF_8);
    }

    public static Key generateRandomKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM_DES);
        keyGenerator.init(new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey;
    }

    public static Key generateSecretKey(String key) throws GeneralSecurityException {
        if (null == key) {
            return null;
        }
        return new SecretKeySpec(MailPasswordUtil.ensureLength(key.getBytes(Charsets.UTF_8)), ALGORITHM_DES);
    }

    private static byte[] ensureLength(byte[] bytes) {
        byte[] keyBytes;
        int len = bytes.length;
        if (len < 8) {
            keyBytes = new byte[8];
            System.arraycopy(bytes, 0, keyBytes, 0, len);
            for (int i = len; i < keyBytes.length; ++i) {
                keyBytes[i] = 48;
            }
        } else if (len > 8) {
            keyBytes = new byte[8];
            System.arraycopy(bytes, 0, keyBytes, 0, keyBytes.length);
        } else {
            keyBytes = bytes;
        }
        return keyBytes;
    }
}

