/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.transport.TransportInitialization;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.session.Session;
import javax.mail.Address;

public abstract class MailTransport {
    static final void startupImpl(MailTransport transport) throws OXException {
        transport.startup();
    }

    static final void shutdownImpl(MailTransport transport) throws OXException {
        transport.shutdown();
    }

    public static final MailTransport getInstance(Session session) throws OXException {
        return MailTransport.getInstance(session, 0);
    }

    public static final MailTransport getInstance(Session session, int accountId) throws OXException {
        if (!TransportInitialization.getInstance().isInitialized()) {
            throw MailExceptionCode.INITIALIZATION_PROBLEM.create();
        }
        return TransportProviderRegistry.getTransportProviderBySession(session, accountId).createNewMailTransport(session, accountId);
    }

    public MailMessage sendMailMessage(ComposedMailMessage transportMail, ComposeType sendType) throws OXException {
        return this.sendMailMessage(transportMail, sendType, null);
    }

    public abstract MailMessage sendMailMessage(ComposedMailMessage var1, ComposeType var2, Address[] var3) throws OXException;

    public MailMessage sendRawMessage(byte[] asciiBytes) throws OXException {
        return this.sendRawMessage(asciiBytes, null);
    }

    public abstract MailMessage sendRawMessage(byte[] var1, Address[] var2) throws OXException;

    public abstract void sendReceiptAck(MailMessage var1, String var2) throws OXException;

    public abstract void ping() throws OXException;

    public abstract void close() throws OXException;

    public abstract TransportConfig getTransportConfig() throws OXException;

    protected abstract void startup() throws OXException;

    protected abstract void shutdown() throws OXException;

    protected abstract ITransportProperties createNewMailProperties() throws OXException;
}

