/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure.handler;

import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.exception.OXException;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.ParameterizedHeader;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.structure.Base64JSONString;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedPart;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.regex.MatcherReplacer;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class MIMEStructureHandler
implements StructureHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MIMEStructureHandler.class));
    private static final MailDateFormat MAIL_DATE_FORMAT = new MailDateFormat();
    private static final String KEY_ID;
    private static final String KEY_HEADERS;
    private static final String BODY = "body";
    private static final String DATA = "data";
    private static final String CONTENT_TRANSFER_ENCODING = "content-transfer-encoding";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String CONTENT_TYPE = "content-type";
    private final LinkedList<JSONObject> mailJsonObjectQueue = new LinkedList();
    private JSONObject currentMailObject = new JSONObject();
    private JSONValue currentBodyObject;
    private final long maxSize;
    private JSONArray userFlags;
    private int multipartCount;
    private boolean forceJSONArray4Multipart;
    private static final int MB = 0x100000;
    private static final int BUFLEN = 8192;
    private static final Set<String> REMAIN;
    private static final String PRIMARY_TEXT = "text/";
    private static final String TEXT_HTML = "text/htm";
    private static final Pattern PAT_META_CT;
    private static final HeaderName HN_CONTENT_TYPE;
    private static final HeaderName HN_DATE;
    private static final Set<HeaderName> PARAMETERIZED_HEADERS;
    private static final Set<HeaderName> ADDRESS_HEADERS;
    private static final Pattern P_DOUBLE_BACKSLASH;

    public MIMEStructureHandler(long maxSize) {
        this.mailJsonObjectQueue.addLast(this.currentMailObject);
        this.maxSize = maxSize;
        this.forceJSONArray4Multipart = true;
    }

    public MIMEStructureHandler setForceJSONArray4Multipart(boolean forceJSONArray4Multipart) {
        this.forceJSONArray4Multipart = forceJSONArray4Multipart;
        return this;
    }

    @Override
    public boolean handleEnd(MailMessage mail) throws OXException {
        JSONObject headersJsonObject = this.mailJsonObjectQueue.getFirst().optJSONObject(KEY_HEADERS);
        if (null == headersJsonObject) {
            return true;
        }
        UnsynchronizedByteArrayOutputStream buf = new UnsynchronizedByteArrayOutputStream(2048);
        MimeMessageUtility.writeHeaders(mail, (OutputStream)buf);
        byte[] bytes = buf.toByteArray();
        int length = bytes.length;
        if (length <= 0 || length >= 0x100000) {
            return true;
        }
        try {
            headersJsonObject.put("x-original-headers", (Object)new String(Base64.encodeBase64((byte[])bytes)));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    public JSONObject getJSONMailObject() {
        return this.mailJsonObjectQueue.getFirst();
    }

    private JSONArray getUserFlags() throws JSONException {
        if (null == this.userFlags) {
            this.userFlags = new JSONArray();
            this.currentMailObject.put(MailJSONField.USER.getKey(), (Object)this.userFlags);
        }
        return this.userFlags;
    }

    private void add2BodyJsonObject(JSONObject bodyObject) throws JSONException {
        if (null == this.currentBodyObject) {
            if (this.forceJSONArray4Multipart && this.multipartCount > 0) {
                JSONArray jsonArray = new JSONArray();
                jsonArray.put((Object)bodyObject);
                this.currentBodyObject = jsonArray;
            } else {
                this.currentBodyObject = bodyObject;
            }
            this.currentMailObject.put(BODY, (Object)this.currentBodyObject);
        } else {
            JSONArray jsonArray;
            JSONValue prev = this.currentBodyObject;
            if (prev.isArray()) {
                jsonArray = prev.toArray();
            } else {
                jsonArray = new JSONArray();
                jsonArray.put((Object)prev);
                this.currentBodyObject = jsonArray;
                this.currentMailObject.put(BODY, (Object)this.currentBodyObject);
            }
            jsonArray.put((Object)bodyObject);
        }
    }

    @Override
    public boolean handleAttachment(MailPart part, String id) throws OXException {
        ICalParser iCalParser;
        ContentType contentType = part.getContentType();
        if (MIMEStructureHandler.isVCalendar(contentType.getBaseType()) && !contentType.containsParameter("method") && (iCalParser = ServerServiceRegistry.getInstance().getService(ICalParser.class)) != null) {
            try {
                String method = iCalParser.parseProperty("METHOD", part.getInputStream());
                if (null != method) {
                    contentType.setParameter("method", MIMEStructureHandler.toUpperCase(method));
                    part.setContentType(contentType);
                }
            }
            catch (RuntimeException e) {
                LOG.warn((Object)"A runtime error occurred.", (Throwable)e);
            }
        }
        this.addBodyPart(part, id);
        return true;
    }

    @Override
    public boolean handleSMIMEBodyText(MailPart part) throws OXException {
        try {
            JSONObject bodyObject = new JSONObject();
            JSONObject headerObject = new JSONObject();
            this.fillBodyPart(bodyObject, part, headerObject, null);
            JSONObject jType = headerObject.optJSONObject(CONTENT_TYPE);
            if (null != jType) {
                bodyObject.put("type", (Object)jType.getString("type"));
            }
            JSONObject jsonObject = this.currentMailObject;
            for (String name : new HashSet(jsonObject.keySet())) {
                if (REMAIN.contains(name)) continue;
                jsonObject.remove(name);
            }
            jsonObject.put("smime_body_text", (Object)bodyObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSMIMEBodyData(byte[] data) throws OXException {
        try {
            this.currentMailObject.put("smime_body_data", (Object)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])data, (boolean)false)));
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        try {
            this.currentMailObject.put(MailJSONField.COLOR_LABEL.getKey(), colorLabel);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleHeaders(Iterator<Map.Entry<String, String>> iter) throws OXException {
        this.generateHeadersObject(iter, this.currentMailObject);
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(final UUEncodedPart part, String id) throws OXException {
        String encodeFN;
        String filename = part.getFileName();
        String contentType = "application/octet-stream";
        try {
            contentType = MimeType2ExtMap.getContentType(new File(filename.toLowerCase()).getName()).toLowerCase();
        }
        catch (Exception e) {
            Throwable t = new Throwable("Unable to fetch content-type for '" + filename + "': " + e);
            LOG.warn((Object)t.getMessage(), t);
        }
        StringAllocator sb = new StringAllocator(64);
        HashMap<String, String> headers = new HashMap<String, String>(4);
        try {
            encodeFN = MimeUtility.encodeText((String)filename, (String)"UTF-8", (String)"Q");
        }
        catch (UnsupportedEncodingException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        headers.put(CONTENT_TYPE, sb.append(contentType).append("; name=").append(encodeFN).toString());
        headers.put(CONTENT_DISPOSITION, new StringAllocator("attachment").append("; filename=").append(encodeFN).toString());
        headers.put(CONTENT_TRANSFER_ENCODING, "base64");
        this.addBodyPart(part.getFileSize(), new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return part.getInputStream();
            }
        }, new ContentType(contentType), id, headers.entrySet().iterator());
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(final String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        headers.put(CONTENT_TYPE, "text/plain; charset=UTF-8");
        headers.put(CONTENT_DISPOSITION, "inline");
        this.addBodyPart(size, new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new UnsynchronizedByteArrayInputStream(decodedTextContent.getBytes(Charsets.UTF_8));
            }
        }, contentType, id, headers.entrySet().iterator());
        return true;
    }

    @Override
    public boolean handleMultipartStart(ContentType contentType, int bodyPartCount, String id) throws OXException {
        try {
            if (++this.multipartCount > 1) {
                JSONObject newMailObject = new JSONObject();
                this.add2BodyJsonObject(newMailObject);
                this.currentMailObject = newMailObject;
                this.mailJsonObjectQueue.addLast(this.currentMailObject);
                this.currentBodyObject = null;
                HashMap<String, String> headers = new HashMap<String, String>(1);
                headers.put(CONTENT_TYPE, contentType.toString());
                this.generateHeadersObject(headers.entrySet().iterator(), this.currentMailObject);
            } else {
                JSONObject headers = this.currentMailObject.optJSONObject(KEY_HEADERS);
                if (null == headers) {
                    HashMap<String, String> headersMap = new HashMap<String, String>(1);
                    headersMap.put(CONTENT_TYPE, contentType.toString());
                    this.generateHeadersObject(headersMap.entrySet().iterator(), this.currentMailObject);
                } else {
                    headers.put(CONTENT_TYPE, (Object)this.generateParameterizedHeader(contentType, MIMEStructureHandler.toLowerCase(contentType.getBaseType())));
                }
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleMultipartEnd() throws OXException {
        if (--this.multipartCount > 0) {
            this.mailJsonObjectQueue.removeLast();
            this.currentMailObject = this.mailJsonObjectQueue.getLast();
            this.currentBodyObject = (JSONValue)this.currentMailObject.opt(BODY);
        }
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        try {
            JSONObject bodyObject;
            MailMessage nestedMail;
            Object content = mailPart.getContent();
            if (content instanceof MailMessage) {
                nestedMail = (MailMessage)content;
            } else if (content instanceof InputStream) {
                try {
                    nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)content));
                }
                catch (MessagingException e) {
                    throw MimeMailException.handleMessagingException(e);
                }
            } else {
                StringAllocator sb = new StringAllocator(128);
                sb.append("Ignoring nested message.").append("Cannot handle part's content which should be a RFC822 message according to its content type: ");
                sb.append(null == content ? "null" : content.getClass().getSimpleName());
                LOG.error((Object)sb.toString());
                return true;
            }
            MIMEStructureHandler inner = new MIMEStructureHandler(this.maxSize);
            new StructureMailMessageParser().setParseTNEFParts(true).parseMailMessage(nestedMail, inner, id);
            if (this.multipartCount > 0) {
                bodyObject = new JSONObject();
                this.generateHeadersObject(mailPart.getHeadersIterator(), bodyObject);
                JSONObject jsonMailObject = inner.getJSONMailObject();
                jsonMailObject.put(KEY_ID, (Object)(mailPart.containsSequenceId() ? mailPart.getSequenceId() : id));
                bodyObject.put(BODY, (Object)jsonMailObject);
            } else {
                bodyObject = inner.getJSONMailObject();
            }
            this.add2BodyJsonObject(bodyObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        try {
            if (receivedDate == null) {
                this.currentMailObject.put(MailJSONField.RECEIVED_DATE.getKey(), JSONObject.NULL);
            } else {
                JSONObject dateObject = new JSONObject();
                dateObject.put("utc", receivedDate.getTime());
                MailDateFormat mailDateFormat = MAIL_DATE_FORMAT;
                synchronized (mailDateFormat) {
                    dateObject.put("date", (Object)MAIL_DATE_FORMAT.format(receivedDate));
                }
                this.currentMailObject.put(MailJSONField.RECEIVED_DATE.getKey(), (Object)dateObject);
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        try {
            String key = MailJSONField.FLAGS.getKey();
            if (this.currentMailObject.hasAndNotNull(key)) {
                int prevFlags = this.currentMailObject.getInt(key);
                this.currentMailObject.put(key, prevFlags | flags);
            } else {
                this.currentMailObject.put(key, flags);
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        if (null == userFlags || 0 == userFlags.length) {
            return true;
        }
        try {
            JSONArray userFlagsArr = this.getUserFlags();
            for (String userFlag : userFlags) {
                userFlagsArr.put((Object)userFlag);
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void addBodyPart(MailPart part, String id) throws OXException {
        try {
            JSONObject bodyObject = new JSONObject();
            if (this.multipartCount > 0) {
                JSONObject headersObject = this.generateHeadersObject(part.getHeadersIterator(), bodyObject);
                JSONObject body = new JSONObject();
                this.fillBodyPart(body, part, headersObject, id);
                bodyObject.put(BODY, (Object)body);
            } else {
                JSONObject headersJSONObject = this.currentMailObject.optJSONObject(KEY_HEADERS);
                this.fillBodyPart(bodyObject, part, null == headersJSONObject ? new JSONObject() : headersJSONObject, id);
            }
            this.add2BodyJsonObject(bodyObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void addBodyPart(long size, InputStreamProvider isp, ContentType contentType, String id, Iterator<Map.Entry<String, String>> iter) throws OXException {
        try {
            JSONObject bodyObject = new JSONObject();
            if (this.multipartCount > 0) {
                JSONObject headersObject = this.generateHeadersObject(iter, bodyObject);
                JSONObject body = new JSONObject();
                this.fillBodyPart(body, size, isp, contentType, headersObject, id);
                bodyObject.put(BODY, (Object)body);
            } else {
                JSONObject headersJSONObject = this.currentMailObject.optJSONObject(KEY_HEADERS);
                this.fillBodyPart(bodyObject, size, isp, contentType, null == headersJSONObject ? new JSONObject() : headersJSONObject, id);
            }
            this.add2BodyJsonObject(bodyObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void fillBodyPart(JSONObject bodyObject, MailPart part, JSONObject headerObject, String id) throws OXException {
        try {
            if (null != id) {
                bodyObject.put(KEY_ID, (Object)id);
            }
            long size = part.getSize();
            if (this.maxSize > 0L && size > this.maxSize) {
                bodyObject.put(DATA, JSONObject.NULL);
            } else {
                ContentType contentType = part.getContentType();
                if (contentType.startsWith(PRIMARY_TEXT)) {
                    if (contentType.startsWith("text/comma-separated-values")) {
                        MIMEStructureHandler.fillBase64JSONString(part.getInputStream(), bodyObject, true);
                        headerObject.put(CONTENT_TRANSFER_ENCODING, (Object)"base64");
                        contentType.setPrimaryType("application").setSubType("vnd.ms-excel");
                        headerObject.put(CONTENT_TYPE, (Object)this.generateParameterizedHeader(contentType, MIMEStructureHandler.toLowerCase(contentType.getBaseType())));
                    } else {
                        if (contentType.startsWith(TEXT_HTML)) {
                            String html = MIMEStructureHandler.readContent(part, contentType);
                            Matcher m = PAT_META_CT.matcher(html);
                            MatcherReplacer mr = new MatcherReplacer(m, html);
                            StringBuilder replaceBuffer = new StringBuilder(html.length());
                            if (m.find()) {
                                replaceBuffer.append("<meta content=\"").append(MIMEStructureHandler.toLowerCase(contentType.getBaseType()));
                                replaceBuffer.append("; charset=UTF-8\" http-equiv=\"Content-Type\" />");
                                String replacement = replaceBuffer.toString();
                                replaceBuffer.setLength(0);
                                mr.appendLiteralReplacement(replaceBuffer, replacement);
                            }
                            mr.appendTail(replaceBuffer);
                            bodyObject.put(DATA, (Object)replaceBuffer.toString());
                        } else {
                            bodyObject.put(DATA, (Object)MIMEStructureHandler.readContent(part, contentType));
                        }
                        headerObject.remove(CONTENT_TRANSFER_ENCODING);
                        contentType.setCharsetParameter("UTF-8");
                        headerObject.put(CONTENT_TYPE, (Object)this.generateParameterizedHeader(contentType, MIMEStructureHandler.toLowerCase(contentType.getBaseType())));
                    }
                } else {
                    MIMEStructureHandler.fillBase64JSONString(part.getInputStream(), bodyObject, true);
                    headerObject.put(CONTENT_TRANSFER_ENCODING, (Object)"base64");
                }
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private void fillBodyPart(JSONObject bodyObject, long size, InputStreamProvider isp, ContentType contentType, JSONObject headerObject, String id) throws OXException {
        try {
            bodyObject.put(KEY_ID, (Object)id);
            if (this.maxSize > 0L && size > this.maxSize) {
                bodyObject.put(DATA, JSONObject.NULL);
            } else if (contentType.startsWith(PRIMARY_TEXT)) {
                if (contentType.startsWith("text/comma-separated-values")) {
                    MIMEStructureHandler.fillBase64JSONString(isp.getInputStream(), bodyObject, true);
                    headerObject.put(CONTENT_TRANSFER_ENCODING, (Object)"base64");
                    contentType.setPrimaryType("application").setSubType("vnd.ms-excel");
                    headerObject.put(CONTENT_TYPE, (Object)this.generateParameterizedHeader(contentType, MIMEStructureHandler.toLowerCase(contentType.getBaseType())));
                } else {
                    bodyObject.put(DATA, (Object)MIMEStructureHandler.readContent(isp, contentType));
                    headerObject.remove(CONTENT_TRANSFER_ENCODING);
                    contentType.setCharsetParameter("UTF-8");
                    headerObject.put(CONTENT_TYPE, (Object)this.generateParameterizedHeader(contentType, MIMEStructureHandler.toLowerCase(contentType.getBaseType())));
                }
            } else {
                MIMEStructureHandler.fillBase64JSONString(isp.getInputStream(), bodyObject, true);
                headerObject.put(CONTENT_TRANSFER_ENCODING, (Object)"base64");
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static void fillBase64JSONString(InputStream inputStream, JSONObject bodyObject, boolean streaming) throws OXException {
        block10: {
            try {
                byte[] bytes;
                if (streaming) {
                    bodyObject.put(DATA, (Object)new Base64JSONString(inputStream));
                    break block10;
                }
                try {
                    int read;
                    byte[] buf = new byte[8192];
                    UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(32768);
                    while ((read = inputStream.read(buf, 0, 8192)) > 0) {
                        out.write(buf, 0, read);
                    }
                    bytes = out.toByteArray();
                }
                catch (IOException e) {
                    if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                        throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                    }
                    throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                }
                finally {
                    Streams.close((Closeable)inputStream);
                }
                bodyObject.put(DATA, (Object)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])bytes, (boolean)false)));
            }
            catch (JSONException e) {
                throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
            }
        }
    }

    private JSONObject generateHeadersObject(Iterator<Map.Entry<String, String>> iter, JSONObject parent) throws OXException {
        try {
            JSONObject hdrObject = new JSONObject();
            while (iter.hasNext()) {
                JSONArray ja;
                Map.Entry<String, String> entry = iter.next();
                String name = MIMEStructureHandler.toLowerCase(entry.getKey());
                HeaderName headerName = HeaderName.valueOf(name);
                if (ADDRESS_HEADERS.contains(headerName)) {
                    InternetAddress[] internetAddresses = MIMEStructureHandler.getAddressHeader(entry.getValue());
                    if (hdrObject.has(name)) {
                        ja = hdrObject.getJSONArray(name);
                    } else {
                        ja = new JSONArray();
                        hdrObject.put(name, (Object)ja);
                    }
                    for (InternetAddress internetAddress : internetAddresses) {
                        String address = IDNA.toIDN((String)internetAddress.getAddress());
                        if (MIMEStructureHandler.isEmpty(address)) continue;
                        JSONObject addressJsonObject = new JSONObject();
                        String personal = internetAddress.getPersonal();
                        if (null != personal) {
                            addressJsonObject.put("personal", (Object)P_DOUBLE_BACKSLASH.matcher(personal).replaceAll("\\\""));
                        }
                        addressJsonObject.put("address", (Object)address);
                        ja.put((Object)addressJsonObject);
                    }
                    continue;
                }
                if (PARAMETERIZED_HEADERS.contains(headerName)) {
                    JSONObject parameterJsonObject = this.generateParameterizedHeader(entry.getValue(), headerName);
                    if (hdrObject.has(name)) {
                        JSONArray ja2;
                        Object previous = hdrObject.get(name);
                        if (previous instanceof JSONArray) {
                            ja2 = (JSONArray)previous;
                        } else {
                            ja2 = new JSONArray();
                            hdrObject.put(name, (Object)ja2);
                            ja2.put(previous);
                        }
                        ja2.put((Object)parameterJsonObject);
                        continue;
                    }
                    hdrObject.put(name, (Object)parameterJsonObject);
                    continue;
                }
                if (HN_DATE.equals(headerName)) {
                    hdrObject.put(name, this.generateDateObject(entry.getValue()));
                    continue;
                }
                if (hdrObject.has(name)) {
                    Object previous = hdrObject.get(name);
                    if (previous instanceof JSONArray) {
                        ja = (JSONArray)previous;
                    } else {
                        ja = new JSONArray();
                        hdrObject.put(name, (Object)ja);
                        ja.put(previous);
                    }
                    ja.put((Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
                    continue;
                }
                hdrObject.put(name, (Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
            }
            parent.put(KEY_HEADERS, hdrObject.length() > 0 ? hdrObject : JSONObject.NULL);
            return hdrObject;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private JSONObject generateParameterizedHeader(String value, HeaderName headerName) throws OXException, JSONException {
        if (HN_CONTENT_TYPE.equals(headerName)) {
            ContentType ct = new ContentType(value);
            return this.generateParameterizedHeader(ct, MIMEStructureHandler.toLowerCase(ct.getBaseType()));
        }
        ContentDisposition cd = new ContentDisposition(value);
        return this.generateParameterizedHeader(cd, MIMEStructureHandler.toLowerCase(cd.getDisposition()));
    }

    private JSONObject generateParameterizedHeader(ParameterizedHeader parameterizedHeader, String type) throws JSONException {
        JSONObject parameterJsonObject = new JSONObject();
        parameterJsonObject.put("type", (Object)type);
        JSONObject paramListJsonObject = new JSONObject();
        Iterator<String> pi = parameterizedHeader.getParameterNames();
        while (pi.hasNext()) {
            String paramName = pi.next();
            if ("read-date".equalsIgnoreCase(paramName)) {
                paramListJsonObject.put(MIMEStructureHandler.toLowerCase(paramName), this.generateDateObject(parameterizedHeader.getParameter(paramName)));
                continue;
            }
            paramListJsonObject.put(MIMEStructureHandler.toLowerCase(paramName), (Object)parameterizedHeader.getParameter(paramName));
        }
        if (paramListJsonObject.length() > 0) {
            parameterJsonObject.put("params", (Object)paramListJsonObject);
        }
        return parameterJsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object generateDateObject(String date) throws JSONException {
        if (null == date) {
            return JSONObject.NULL;
        }
        JSONObject dateObject = new JSONObject();
        MailDateFormat mailDateFormat = MAIL_DATE_FORMAT;
        synchronized (mailDateFormat) {
            try {
                Date parsedDate = MAIL_DATE_FORMAT.parse(date);
                if (null != parsedDate) {
                    dateObject.put("utc", parsedDate.getTime());
                }
            }
            catch (ParseException pex) {
                LOG.warn((Object)("Date string could not be parsed: " + date));
            }
        }
        dateObject.put("date", (Object)date);
        return dateObject;
    }

    private static InternetAddress[] getAddressHeader(String addresses) {
        if (null == addresses || 0 == addresses.length()) {
            return new InternetAddress[0];
        }
        try {
            return QuotedInternetAddress.parseHeader(addresses, true);
        }
        catch (AddressException e) {
            return MIMEStructureHandler.getAddressHeaderNonStrict(addresses);
        }
    }

    private static InternetAddress[] getAddressHeaderNonStrict(String addressStrings) {
        try {
            InternetAddress[] addresses = QuotedInternetAddress.parseHeader(addressStrings, false);
            ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>(addresses.length);
            for (InternetAddress internetAddress : addresses) {
                try {
                    addressList.add(new QuotedInternetAddress(internetAddress.toString()));
                }
                catch (AddressException e) {
                    addressList.add(internetAddress);
                }
            }
            return addressList.toArray(new InternetAddress[addressList.size()]);
        }
        catch (AddressException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringAllocator(128).append("Internet addresses could not be properly parsed: \"").append(e.getMessage()).append("\". Using plain addresses' string representation instead.").toString(), (Throwable)e);
            }
            return MIMEStructureHandler.getAddressesOnParseError(addressStrings);
        }
    }

    private static InternetAddress[] getAddressesOnParseError(String addr) {
        return new InternetAddress[]{new PlainTextAddress(addr)};
    }

    private static String readContent(MailPart mailPart, ContentType contentType) throws OXException, IOException {
        String charset = MIMEStructureHandler.getCharset(mailPart, contentType);
        try {
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "US-ASCII";
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringAllocator("Character conversion exception while reading content with charset \"").append(charset).append("\". Using fallback charset \"").append("US-ASCII").append("\" instead."), (Throwable)e);
            }
            return MessageUtility.readMailPart(mailPart, "US-ASCII");
        }
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader("Content-Type")) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                StringAllocator sb = null;
                if (null != cs) {
                    sb = new StringAllocator(64).append("Illegal or unsupported encoding: \"").append(cs).append("\".");
                }
                if (contentType.startsWith(PRIMARY_TEXT)) {
                    cs = CharsetDetector.detectCharset((InputStream)mailPart.getInputStream());
                    if (LOG.isWarnEnabled() && null != sb) {
                        sb.append(" Using auto-detected encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                } else {
                    cs = MailProperties.getInstance().getDefaultMimeCharset();
                    if (LOG.isWarnEnabled() && null != sb) {
                        sb.append(" Using fallback encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                }
            }
            charset = cs;
        } else {
            charset = contentType.startsWith(PRIMARY_TEXT) ? CharsetDetector.detectCharset((InputStream)mailPart.getInputStream()) : MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }

    private static String readContent(InputStreamProvider isp, ContentType contentType) throws IOException {
        String charset = MIMEStructureHandler.getCharset(isp, contentType);
        try {
            return MessageUtility.readStream(isp.getInputStream(), charset);
        }
        catch (CharConversionException e) {
            String fallback = "US-ASCII";
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringAllocator("Character conversion exception while reading content with charset \"").append(charset).append("\". Using fallback charset \"").append("US-ASCII").append("\" instead."), (Throwable)e);
            }
            return MessageUtility.readStream(isp.getInputStream(), "US-ASCII");
        }
    }

    private static String getCharset(InputStreamProvider isp, ContentType contentType) throws IOException {
        String cs;
        String charset = contentType.startsWith(PRIMARY_TEXT) ? (!CharsetDetector.isValid((String)(cs = contentType.getCharsetParameter())) ? CharsetDetector.detectCharset((InputStream)isp.getInputStream()) : cs) : MailProperties.getInstance().getDefaultMimeCharset();
        return charset;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private static boolean isVCalendar(String baseContentType) {
        return "text/calendar".equalsIgnoreCase(baseContentType) || "text/x-vcalendar".equalsIgnoreCase(baseContentType);
    }

    private static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    static {
        MAIL_DATE_FORMAT.setTimeZone(TimeZoneUtils.getTimeZone("GMT"));
        KEY_ID = MailListField.ID.getKey();
        KEY_HEADERS = MailJSONField.HEADERS.getKey();
        REMAIN = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(KEY_HEADERS, MailJSONField.RECEIVED_DATE.getKey())));
        PAT_META_CT = Pattern.compile("<meta[^>]*?http-equiv=\"?content-type\"?[^>]*?>", 2);
        HN_CONTENT_TYPE = HeaderName.valueOf(CONTENT_TYPE);
        HN_DATE = HeaderName.valueOf("date");
        PARAMETERIZED_HEADERS = new HashSet<HeaderName>(Arrays.asList(HN_CONTENT_TYPE, HeaderName.valueOf(CONTENT_DISPOSITION)));
        ADDRESS_HEADERS = new HashSet<HeaderName>(Arrays.asList(HeaderName.valueOf("From"), HeaderName.valueOf("To"), HeaderName.valueOf("Cc"), HeaderName.valueOf("Bcc"), HeaderName.valueOf("Reply-To"), HeaderName.valueOf("Sender"), HeaderName.valueOf("Errors-To"), HeaderName.valueOf("Resent-Bcc"), HeaderName.valueOf("Resent-Cc"), HeaderName.valueOf("Resent-From"), HeaderName.valueOf("Resent-To"), HeaderName.valueOf("Resent-Sender"), HeaderName.valueOf("Disposition-Notification-To")));
        P_DOUBLE_BACKSLASH = Pattern.compile(Pattern.quote("\\\\\\\""));
    }

    private static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

