/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import java.util.NoSuchElementException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;

public final class FullnameFolder
extends Folder {
    private final char separator;
    private final String fullname;
    private final boolean hasAll;
    private final String[] uids;

    public FullnameFolder(String fullname, char separator, String[] uids) {
        super(null);
        if (null == uids) {
            throw new IllegalArgumentException("uids is null");
        }
        this.fullname = fullname;
        this.separator = separator;
        this.uids = uids;
        this.hasAll = true;
    }

    public FullnameFolder(String fullname, char separator, String uid) {
        super(null);
        if (null == uid) {
            throw new IllegalArgumentException("uid is invalid");
        }
        this.fullname = fullname;
        this.separator = separator;
        this.uids = new String[]{uid};
        this.hasAll = false;
    }

    public void appendMessages(Message[] msgs) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.appendMessages()");
    }

    public void close(boolean expunge) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.close()");
    }

    public boolean create(int type) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.create()");
    }

    public boolean delete(boolean recurse) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.delete()");
    }

    public boolean exists() throws MessagingException {
        return true;
    }

    public Message[] expunge() throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.expunge()");
    }

    public Folder getFolder(String name) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.getFolder()");
    }

    public String getFullName() {
        return this.fullname;
    }

    public Message getMessage(int msgnum) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.getMessage()");
    }

    public int getMessageCount() throws MessagingException {
        if (this.hasAll) {
            return this.uids.length;
        }
        throw new UnsupportedOperationException("FullnameFolder.getMessageCount()");
    }

    public String getName() {
        throw new UnsupportedOperationException("FullnameFolder.getName()");
    }

    public Folder getParent() throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.getParent()");
    }

    public Flags getPermanentFlags() {
        throw new UnsupportedOperationException("FullnameFolder.getPermanentFlags()");
    }

    public char getSeparator() throws MessagingException {
        return this.separator;
    }

    public int getType() throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.getType()");
    }

    public boolean hasNewMessages() throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.hasNewMessages()");
    }

    public boolean isOpen() {
        throw new UnsupportedOperationException("FullnameFolder.isOpen()");
    }

    public Folder[] list(String pattern) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.list()");
    }

    public void open(int mode) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.open()");
    }

    public boolean renameTo(Folder f) throws MessagingException {
        throw new UnsupportedOperationException("FullnameFolder.renameTo()");
    }

    public String getUID(Message message) {
        if (this.hasAll) {
            if (this.uids.length < message.getMessageNumber()) {
                throw new NoSuchElementException("Message does not belong to folder");
            }
            return this.uids[message.getMessageNumber() - 1];
        }
        return this.uids[0];
    }
}

