/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONValue;

@Action(method=RequestMethod.GET, name="updates", description="Get updated mails", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="Just an empty JSON array is going to be returned since this action cannot be applied to IMAP.")
public final class GetUpdatesAction
extends AbstractMailAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GetUpdatesAction.class));
    private final transient MessageWriter.MailFieldWriter WRITER_ID = MessageWriter.getMailFieldWriter(new MailListField[]{MailListField.ID})[0];

    public GetUpdatesAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            ServerSession session = req.getSession();
            String folderId = req.checkParameter("folder");
            String ignore = req.getParameter("ignore");
            String tmp = req.getParameter("timezone");
            TimeZone timeZone = GetUpdatesAction.isEmpty(tmp) ? null : TimeZoneUtils.getTimeZone(tmp.trim());
            tmp = null;
            boolean bIgnoreDelete = false;
            boolean bIgnoreModified = false;
            if (ignore != null && ignore.indexOf("deleted") != -1) {
                bIgnoreDelete = true;
            }
            if (ignore != null && ignore.indexOf("changed") != -1) {
                bIgnoreModified = true;
            }
            OXJSONWriter jsonWriter = new OXJSONWriter();
            jsonWriter.array();
            if (!bIgnoreModified || !bIgnoreDelete) {
                int[] columns = req.checkIntArray("columns");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                MailServletInterface mailInterface = this.getMailInterface(req);
                if (!bIgnoreModified) {
                    MailMessage[] modified = mailInterface.getUpdatedMessages(folderId, columns);
                    MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                    for (MailMessage mail : modified) {
                        JSONArray ja = new JSONArray();
                        if (mail == null) continue;
                        for (MessageWriter.MailFieldWriter writer : writers) {
                            writer.writeField((JSONValue)ja, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                        }
                        jsonWriter.value(ja);
                    }
                }
                if (!bIgnoreDelete) {
                    MailMessage[] deleted;
                    for (MailMessage mail : deleted = mailInterface.getDeletedMessages(folderId, columns)) {
                        JSONArray ja = new JSONArray();
                        this.WRITER_ID.writeField((JSONValue)ja, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                        jsonWriter.value(ja);
                    }
                }
            }
            jsonWriter.endArray();
            return new AJAXRequestResult((Object)jsonWriter.getObject(), "json");
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }
}

