/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.event.EventPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class MailSessionEventHandler
implements EventHandler {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailSessionEventHandler.class));
    static final boolean DEBUG = LOG.isDebugEnabled();

    public static String[] getTopics() {
        return new String[]{"com/openexchange/sessiond/remove/session", "com/openexchange/sessiond/remove/data", "com/openexchange/sessiond/remove/container"};
    }

    public void handleEvent(Event event) {
        CustomRunnable r = new CustomRunnable(event);
        ThreadPoolService threadPoolService = ThreadPools.getThreadPool();
        if (null == threadPoolService) {
            r.run();
        } else {
            threadPoolService.submit(ThreadPools.task((Runnable)r), CallerRunsBehavior.getInstance());
        }
    }

    private static final class CustomRunnable
    implements Runnable {
        private final Event event;

        CustomRunnable(Event event) {
            this.event = event;
        }

        @Override
        public void run() {
            String topic = this.event.getTopic();
            try {
                if ("com/openexchange/sessiond/remove/session".equals(topic)) {
                    CustomRunnable.dropSessionCaches((Session)this.event.getProperty("com.openexchange.sessiond.session"));
                } else if ("com/openexchange/sessiond/remove/data".equals(topic) || "com/openexchange/sessiond/remove/container".equals(topic)) {
                    Map sessionContainer = (Map)this.event.getProperty("com.openexchange.sessiond.container");
                    for (Session session : sessionContainer.values()) {
                        CustomRunnable.dropSessionCaches(session);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)MessageFormat.format("Error while handling session event \"{0}\": {1}", topic, e.getMessage()), (Throwable)e);
            }
        }

        private static void dropSessionCaches(Session session) {
            EventPool eventPool;
            SessiondService sessiondService;
            if (null == session || session.isTransient()) {
                return;
            }
            int userId = session.getUserId();
            int contextId = session.getContextId();
            MailSessionCache.dropInstance(session);
            try {
                MailMessageCache.getInstance().removeUserMessages(userId, contextId);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (DEBUG) {
                LOG.debug((Object)new StringAllocator("All session-related caches cleared for removed session ").append(session.getSessionID()).toString());
            }
            if (null != (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class)) && null == sessiondService.getAnyActiveSessionForUser(userId, contextId) && null != (eventPool = EventPool.getInstance())) {
                eventPool.removeByUser(userId, contextId);
                if (DEBUG) {
                    LOG.debug((Object)new StringAllocator("Removed all pooled mail events for user ").append(userId).append(" in context ").append(contextId).toString());
                }
            }
        }
    }
}

