/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.login.LoginHandlerService;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LoginHandlerRegistry {
    private static volatile LoginHandlerRegistry instance;
    private final Map<Class<? extends LoginHandlerService>, LoginHandlerService> handlers = new ConcurrentHashMap<Class<? extends LoginHandlerService>, LoginHandlerService>(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginHandlerRegistry getInstance() {
        LoginHandlerRegistry tmp = instance;
        if (null != tmp) return tmp;
        Class<LoginHandlerRegistry> clazz = LoginHandlerRegistry.class;
        synchronized (LoginHandlerRegistry.class) {
            tmp = instance;
            if (tmp != null) return tmp;
            instance = tmp = new LoginHandlerRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        LoginHandlerRegistry tmp = instance;
        if (null == tmp) return;
        Class<LoginHandlerRegistry> clazz = LoginHandlerRegistry.class;
        synchronized (LoginHandlerRegistry.class) {
            tmp = instance;
            if (tmp == null) return;
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private LoginHandlerRegistry() {
    }

    public boolean addLoginHandler(LoginHandlerService loginHandler) {
        Class<?> clazz = loginHandler.getClass();
        if (this.handlers.containsKey(clazz)) {
            return false;
        }
        this.handlers.put(clazz, loginHandler);
        return true;
    }

    public void removeLoginHandler(LoginHandlerService loginHandler) {
        this.handlers.remove(loginHandler.getClass());
    }

    public Iterator<LoginHandlerService> getLoginHandlers() {
        return Collections.unmodifiableCollection(this.handlers.values()).iterator();
    }
}

