/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.image;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.image.ImageActionFactory;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.java.Charsets;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.session.Session;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.regex.Pattern;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.jacksum.algorithm.MD;
import org.apache.commons.logging.Log;

public final class ImageUtility {
    private static final String UTF_8 = "UTF-8";
    private static final Pattern SPLIT = Pattern.compile("&");
    private static final int RADIX = 10;

    private ImageUtility() {
    }

    public static ImageLocation parseImageLocationFrom(String imageUri) {
        if (null == imageUri) {
            return null;
        }
        int queryStringStart = imageUri.indexOf(63);
        if (queryStringStart < 0) {
            return null;
        }
        String[] nvps = SPLIT.split(imageUri.substring(queryStringStart + 1), 0);
        String accountId = null;
        String folder = null;
        String id = null;
        String imageId = null;
        String timestamp = null;
        String registrationName = null;
        for (String nvp : nvps) {
            int pos;
            if ((nvp = nvp.trim()).length() <= 0 || (pos = nvp.indexOf(61)) < 0) continue;
            String name = nvp.substring(0, pos).toLowerCase(Locale.US);
            if ("accountId".equals(name)) {
                accountId = ImageUtility.decodeQueryStringValue(nvp.substring(pos + 1));
                continue;
            }
            if ("folder".equals(name)) {
                folder = ImageUtility.decodeQueryStringValue(nvp.substring(pos + 1));
                continue;
            }
            if ("id".equals(name)) {
                id = ImageUtility.decodeQueryStringValue(nvp.substring(pos + 1));
                continue;
            }
            if ("uid".equals(name)) {
                imageId = ImageUtility.decodeQueryStringValue(nvp.substring(pos + 1));
                continue;
            }
            if ("timestamp".equals(name)) {
                timestamp = ImageUtility.decodeQueryStringValue(nvp.substring(pos + 1));
                continue;
            }
            if (!"source".equals(name)) continue;
            registrationName = ImageUtility.decodeQueryStringValue(nvp.substring(pos + 1));
        }
        ImageLocation il = new ImageLocation.Builder(imageId).accountId(accountId).folder(folder).id(id).timestamp(timestamp).build();
        if (null == registrationName && null == (registrationName = ImageActionFactory.getRegistrationNameFor(imageUri))) {
            throw new IllegalArgumentException("No known registration name for: " + imageUri);
        }
        il.setRegistrationName(registrationName);
        return il;
    }

    public static ImageLocation parseImageLocationFrom(AJAXRequestData requestData) {
        if (requestData == null) {
            return null;
        }
        String accountId = requestData.getParameter("accountId");
        String folder = requestData.getParameter("folder");
        String id = requestData.getParameter("id");
        String imageId = requestData.getParameter("uid");
        String timestamp = requestData.getParameter("timestamp");
        String registrationName = requestData.getParameter("source");
        ImageLocation il = new ImageLocation.Builder(imageId).accountId(accountId).folder(folder).id(id).timestamp(timestamp).build();
        if (null == registrationName && null == (registrationName = ImageActionFactory.getRegistrationNameFor(requestData.getSerlvetRequestURI()))) {
            throw new IllegalArgumentException("No known registration name for: " + requestData.getSerlvetRequestURI());
        }
        il.setRegistrationName(registrationName);
        return il;
    }

    private static String decodeQueryStringValue(String queryStringValue) {
        try {
            return AJAXServlet.decodeUrl(queryStringValue, UTF_8);
        }
        catch (RuntimeException e) {
            return queryStringValue;
        }
    }

    public static void startImageUrl(ImageLocation imageLocation, Session session, ImageDataSource imageDataSource, boolean preferRelativeUrl, StringBuilder sb) {
        ImageUtility.startImageUrl(imageLocation, session, imageDataSource, preferRelativeUrl, false, sb);
    }

    public static void startImageUrl(ImageLocation imageLocation, Session session, ImageDataSource imageDataSource, boolean preferRelativeUrl, boolean addRoute, StringBuilder sb) {
        String accountId;
        String timestamp;
        String imageId;
        String objectId;
        String folder;
        Boolean noRoute;
        String route;
        String prefix;
        HostData hostData = (HostData)session.getParameter("com.openexchange.groupware.hostdata");
        if (hostData == null) {
            String ajpRoute;
            prefix = "";
            Props properties = LogProperties.optLogProperties();
            route = null == properties ? null : (null == (ajpRoute = (String)properties.get(LogProperties.Name.AJP_HTTP_SESSION)) ? (String)properties.get(LogProperties.Name.GRIZZLY_HTTP_SESSION) : ajpRoute);
        } else {
            if (preferRelativeUrl) {
                prefix = "";
            } else {
                sb.append(hostData.isSecure() ? "https://" : "http://");
                sb.append(hostData.getHost());
                int port = hostData.getPort();
                if (hostData.isSecure() && port != 443 || !hostData.isSecure() && port != 80) {
                    sb.append(':').append(port);
                }
                prefix = sb.toString();
                sb.setLength(0);
            }
            route = hostData.getRoute();
        }
        sb.append(prefix);
        sb.append(DefaultDispatcherPrefixService.getInstance().getPrefix());
        sb.append("image");
        String alias = imageDataSource.getAlias();
        if (null != alias) {
            sb.append(alias);
        }
        if (addRoute && (null == (noRoute = (Boolean)imageLocation.getProperty("__noRoute")) || !noRoute.booleanValue()) && null != route) {
            sb.append(";jsessionid=").append(route);
        }
        boolean first = true;
        if (null == alias) {
            sb.append('?').append("source=").append(ImageUtility.urlEncodeSafe(imageDataSource.getRegistrationName()));
            first = false;
        }
        if (null != (folder = imageLocation.getFolder())) {
            sb.append(first ? (char)'?' : '&').append("folder").append('=').append(ImageUtility.urlEncodeSafe(folder));
            first = false;
        }
        if (null != (objectId = imageLocation.getId())) {
            sb.append(first ? (char)'?' : '&').append("id").append('=').append(ImageUtility.urlEncodeSafe(objectId));
            first = false;
        }
        if (null != (imageId = imageLocation.getImageId())) {
            sb.append(first ? (char)'?' : '&').append("uid").append('=').append(ImageUtility.urlEncodeSafe(imageId));
            first = false;
        }
        if (null != (timestamp = imageLocation.getTimestamp())) {
            sb.append(first ? (char)'?' : '&').append("timestamp").append('=').append(ImageUtility.urlEncodeSafe(timestamp));
            first = false;
        }
        if (null != (accountId = imageLocation.getAccountId())) {
            sb.append(first ? (char)'?' : '&').append("accountId=").append(ImageUtility.urlEncodeSafe(accountId));
            first = false;
        }
    }

    private static String urlEncodeSafe(String text) {
        try {
            return URLEncoder.encode(text, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ImageUtility.class)).error((Object)e.getMessage(), (Throwable)e);
            return text;
        }
    }

    public static String getMD5(String string, String encoding) {
        try {
            MD checksum = new MD("MD5");
            checksum.setEncoding(encoding);
            checksum.update(string.getBytes(Charsets.UTF_8));
            return checksum.getFormattedValue();
        }
        catch (NoSuchAlgorithmException e) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ImageUtility.class)).error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getHash(String string, String algorithm, String encoding) {
        try {
            AbstractChecksum checksum = JacksumAPI.getChecksumInstance((String)algorithm);
            checksum.setEncoding(encoding);
            checksum.update(string.getBytes(UTF_8));
            return checksum.getFormattedValue();
        }
        catch (NoSuchAlgorithmException e) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ImageUtility.class)).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ImageUtility.class)).error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int limit = -2147483647;
        int multmin = -214748364;
        int result = 0;
        int i = 0;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }
}

