/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools;

import java.util.List;

public final class Utility {
    private static final int RADIX = 10;

    private Utility() {
    }

    public static int parsePositiveInt(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    public static String toTable(List<Object[]> rows, String[] columnNames, boolean withBorders) {
        String delimLine;
        int[] maxLengths = new int[columnNames.length];
        for (int i = 0; i < maxLengths.length; ++i) {
            maxLengths[i] = columnNames[i].length();
        }
        for (Object[] row : rows) {
            for (int i = 0; i < row.length; ++i) {
                int a = maxLengths[i];
                int b = row[i].toString().length();
                maxLengths[i] = a >= b ? a : b;
            }
        }
        int size = rows.size();
        StringBuilder sb = new StringBuilder(size * 64);
        if (withBorders) {
            int i;
            sb.append('+').append('-');
            for (i = 0; i < maxLengths[0]; ++i) {
                sb.append('-');
            }
            for (i = 1; i < maxLengths.length; ++i) {
                sb.append('-').append('+').append('-');
                for (int j = 0; j < maxLengths[i]; ++j) {
                    sb.append('-');
                }
            }
            sb.append('-').append('+').append('\n');
            delimLine = sb.toString();
            sb.setLength(0);
        } else {
            delimLine = "";
        }
        sb.append(delimLine);
        Utility.appendValues(columnNames, maxLengths, sb, withBorders);
        sb.append(delimLine);
        for (Object[] row : rows) {
            String[] values = new String[row.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = row[i].toString();
            }
            Utility.appendValues(values, maxLengths, sb, withBorders);
            sb.append(delimLine);
        }
        return sb.toString();
    }

    private static void appendValues(String[] values, int[] maxLengths, StringBuilder sb, boolean withBorders) {
        int i;
        if (withBorders) {
            sb.append('|').append(' ');
        }
        sb.append(values[0]);
        for (i = values[0].length(); i < maxLengths[0]; ++i) {
            sb.append(' ');
        }
        for (i = 1; i < values.length; ++i) {
            sb.append(' ');
            if (withBorders) {
                sb.append('|');
            }
            sb.append(' ');
            sb.append(values[i]);
            for (int j = values[i].length(); j < maxLengths[i]; ++j) {
                sb.append(' ');
            }
        }
        if (withBorders) {
            sb.append(' ').append('|');
        }
        sb.append('\n');
    }
}

