/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.log.Log;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class EnlargeCalendarUid
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        org.apache.commons.logging.Log log = Log.loggerFor(EnlargeCalendarUid.class);
        log.info((Object)("Performing update task " + EnlargeCalendarUid.class.getSimpleName()));
        Connection con = Database.getNoTimeout(params.getContextId(), true);
        try {
            con.setAutoCommit(false);
            for (String table : new String[]{"prg_dates", "del_dates"}) {
                Tools.checkAndModifyColumns(con, table, new Column("uid", "VARCHAR(1024)"));
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(params.getContextId(), true, con);
        }
        log.info((Object)(EnlargeCalendarUid.class.getSimpleName() + " successfully performed."));
    }
}

