/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CorrectWrongAppointmentFolder
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CorrectWrongAppointmentFolder.class));

    @Override
    public int addedWithVersion() {
        return 25;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        String find = "SELECT pd.cid,pd.object_id,pd.member_uid FROM prg_dates_members pd JOIN oxfolder_tree f ON pd.cid=f.cid AND pd.pfid=f.fuid WHERE f.created_from!=pd.member_uid AND f.module=2 AND f.type=1 AND f.default_flag=1";
        Connection con = Database.get(contextId, true);
        Statement stmt = null;
        ResultSet result = null;
        try {
            con.setAutoCommit(false);
            stmt = con.createStatement();
            result = stmt.executeQuery("SELECT pd.cid,pd.object_id,pd.member_uid FROM prg_dates_members pd JOIN oxfolder_tree f ON pd.cid=f.cid AND pd.pfid=f.fuid WHERE f.created_from!=pd.member_uid AND f.module=2 AND f.type=1 AND f.default_flag=1");
            while (result.next()) {
                int member;
                int folderId;
                int pos = 1;
                int cid = result.getInt(pos++);
                int appId = result.getInt(pos++);
                if (-1 == (folderId = this.getPrivateFolder(con, cid, member = result.getInt(pos++)))) {
                    LOG.info((Object)("Unable to correct folder of participant " + member + " for appointment " + appId + " in context " + cid + "."));
                    continue;
                }
                LOG.info((Object)("Setting folder to " + folderId + " of participant " + member + " for appointment " + appId + " in context " + cid + "."));
                this.correctFolder(con, cid, appId, member, folderId);
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBUtils.autocommit(con);
                Database.back(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBUtils.autocommit(con);
        Database.back(contextId, true, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctFolder(Connection con, int cid, int appId, int member, int folderId) {
        String sql = "UPDATE prg_dates_members SET pfid=? WHERE cid=? AND object_id=? AND member_uid=?";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE prg_dates_members SET pfid=? WHERE cid=? AND object_id=? AND member_uid=?");
            int pos = 1;
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, appId);
            stmt.setInt(pos++, member);
            stmt.execute();
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPrivateFolder(Connection con, int cid, int member) {
        String sql = "SELECT fuid FROM oxfolder_tree WHERE cid=? AND created_from=? AND type=? AND module=? AND default_flag=?";
        PreparedStatement stmt = null;
        ResultSet result = null;
        int folderId = -1;
        try {
            stmt = con.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid=? AND created_from=? AND type=? AND module=? AND default_flag=?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, member);
            stmt.setInt(pos++, 1);
            stmt.setInt(pos++, 2);
            stmt.setInt(pos++, 1);
            result = stmt.executeQuery();
            if (result.next()) {
                folderId = result.getInt(1);
            }
            DBUtils.closeSQLStuff(result, stmt);
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(result, stmt);
        }
        return folderId;
    }
}

