/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.CalendarExtendDNColumnTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class CalendarAddUIDIndexTask
extends UpdateTaskAdapter {
    @Override
    public int getPriority() {
        int priority = UpdateTask.UpdateTaskPriority.HIGH.priority;
        return priority;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{CalendarExtendDNColumnTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(cid);
        try {
            con.setAutoCommit(false);
            String[] tables = new String[]{"prg_dates", "del_dates"};
            this.createCalendarIndex(con, tables);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    private void createCalendarIndex(Connection con, String[] tables) {
        org.apache.commons.logging.Log log = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CalendarAddUIDIndexTask.class));
        String name = "uidIndex";
        String[] columns = new String[]{"cid", "uid"};
        StringBuilder sb = new StringBuilder(64);
        for (String table : tables) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    if (log.isInfoEnabled()) {
                        sb.setLength(0);
                        sb.append("Creating new index named \"");
                        sb.append("uidIndex");
                        sb.append("\" with columns (cid,uid) on table ");
                        sb.append(table);
                        sb.append('.');
                        log.info((Object)sb.toString());
                    }
                    Tools.createIndex(con, table, "uidIndex", columns, false);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                sb.setLength(0);
                sb.append("New index named \"");
                sb.append(indexName);
                sb.append("\" with columns (cid,uid) already exists on table ");
                sb.append(table);
                sb.append('.');
                log.info((Object)sb.toString());
            }
            catch (SQLException e) {
                log.error((Object)("Problem adding index " + "uidIndex" + " on table " + table + '.'), (Throwable)e);
            }
        }
    }

    private OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

