/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public final class AddFileAsForUserContacts
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        Connection con = dbService.getForUpdateTask(contextId);
        Statement stmt = null;
        try {
            con.setAutoCommit(false);
            stmt = con.createStatement();
            stmt.executeUpdate("UPDATE prg_contacts SET field90=field01 WHERE userid IS NOT NULL AND field90 IS NULL");
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.autocommit(con);
                dbService.backForUpdateTask(contextId, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        DBUtils.autocommit(con);
        dbService.backForUpdateTask(contextId, con);
    }
}

