/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.mapping;

import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class TargetCosts
implements Mapper<Float> {
    public static final TargetCosts SINGLETON = new TargetCosts();

    protected TargetCosts() {
    }

    @Override
    public int getId() {
        return 307;
    }

    @Override
    public boolean isSet(Task task) {
        return task.containsTargetCosts();
    }

    @Override
    public String getDBColumnName() {
        return "target_costs";
    }

    @Override
    public String getDisplayName() {
        return "Estimated costs";
    }

    @Override
    public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
        if (null == task.getTargetCosts()) {
            stmt.setNull(pos, 6);
        } else {
            stmt.setDouble(pos, Autoboxing.f((Float)task.getTargetCosts()));
        }
    }

    @Override
    public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
        float targetCosts = result.getFloat(pos);
        if (!result.wasNull()) {
            task.setTargetCosts(Autoboxing.F((float)targetCosts));
        }
    }

    @Override
    public boolean equals(Task task1, Task task2) {
        if (task1.getTargetCosts() == null) {
            return task2.getTargetCosts() == null;
        }
        if (task2.getTargetCosts() == null) {
            return task1.getTargetCosts() == null;
        }
        return task1.getTargetCosts().equals(task2.getTargetCosts());
    }

    @Override
    public Float get(Task task) {
        return task.getTargetCosts();
    }

    @Override
    public void set(Task task, Float value) {
        task.setTargetCosts(value);
    }
}

