/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.ExternalParticipant;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.SQL;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.Collections;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class RdbParticipantStorage
extends ParticipantStorage {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(RdbParticipantStorage.class));

    @Override
    protected Map<Integer, Set<InternalParticipant>> selectInternal(Context ctx, Connection con, int[] tasks2, StorageType type) throws OXException {
        HashMap<Integer, HashSet<InternalParticipant>> tmp = new HashMap<Integer, HashSet<InternalParticipant>>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(DBUtils.getIN(SQL.SELECT_PARTS.get((Object)type), tasks2.length));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            for (int taskId : tasks2) {
                stmt.setInt(pos++, taskId);
            }
            result = stmt.executeQuery();
            while (result.next()) {
                HashSet<InternalParticipant> participants;
                pos = 1;
                int taskId = result.getInt(pos++);
                UserParticipant participant = new UserParticipant(result.getInt(pos++));
                Integer groupId = result.getInt(pos++);
                if (result.wasNull()) {
                    groupId = null;
                }
                InternalParticipant taskParticipant = new InternalParticipant(participant, groupId);
                taskParticipant.setConfirm(result.getInt(pos++));
                taskParticipant.setConfirmMessage(result.getString(pos++));
                if (StorageType.REMOVED == type) {
                    int folderId;
                    if (0 == (folderId = result.getInt(pos++))) {
                        taskParticipant.setFolderId(-1);
                    } else {
                        taskParticipant.setFolderId(folderId);
                    }
                }
                if (null == (participants = (HashSet<InternalParticipant>)tmp.get(taskId))) {
                    participants = new HashSet<InternalParticipant>();
                    tmp.put(taskId, participants);
                }
                participants.add(taskParticipant);
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        HashMap<Integer, Set<InternalParticipant>> retval = new HashMap<Integer, Set<InternalParticipant>>();
        retval.putAll(tmp);
        return retval;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void updateInternal(Context ctx, Connection con, int taskId, Set<InternalParticipant> participants, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL.UPDATE_PARTS.get((Object)type));
            for (InternalParticipant participant : participants) {
                int pos = 1;
                if (null == participant.getGroupId()) {
                    stmt.setNull(pos++, 4);
                } else {
                    stmt.setInt(pos++, participant.getGroupId());
                }
                stmt.setInt(pos++, participant.getConfirm());
                stmt.setString(pos++, participant.getConfirmMessage());
                stmt.setInt(pos++, ctx.getContextId());
                stmt.setInt(pos++, taskId);
                stmt.setInt(pos++, participant.getIdentifier());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (DataTruncation e) {
            try {
                throw RdbParticipantStorage.parseTruncated(con, e, type, participants);
                catch (SQLException e2) {
                    throw TaskExceptionCode.SQL_ERROR.create(e2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    @Override
    void deleteInternal(Context ctx, Connection con, int taskId, int[] users, StorageType type, boolean check) throws OXException {
        int deleted;
        if (users.length == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(SQL.DELETE_PARTS.get((Object)type));
        for (int i = 0; i < users.length; ++i) {
            sql.append("?,");
        }
        sql.setCharAt(sql.length() - 1, ')');
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql.toString());
            int counter = 1;
            stmt.setInt(counter++, ctx.getContextId());
            stmt.setInt(counter++, taskId);
            for (int user : users) {
                stmt.setInt(counter++, user);
            }
            deleted = stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
        if (check && users.length != deleted) {
            OXException tske = TaskExceptionCode.PARTICIPANT_DELETE_WRONG.create(users.length, deleted);
            LOG.error((Object)tske.getMessage(), (Throwable)tske);
        }
    }

    @Override
    int[] findTasksWithGroup(Context ctx, Connection con, int groupId, StorageType type) throws OXException {
        ArrayList<Integer> tasks2 = new ArrayList<Integer>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SQL.FIND_GROUP.get((Object)type));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, groupId);
            result = stmt.executeQuery();
            while (result.next()) {
                tasks2.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return Collections.toArray(tasks2);
    }

    @Override
    int[] findTasksWithParticipant(Context ctx, Connection con, int userId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<Integer> tasks2 = new ArrayList<Integer>();
        try {
            stmt = con.prepareStatement(SQL.FIND_PARTICIPANT.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            result = stmt.executeQuery();
            while (result.next()) {
                tasks2.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return Collections.toArray(tasks2);
    }

    @Override
    protected Map<Integer, Set<ExternalParticipant>> selectExternal(Context ctx, Connection con, int[] tasks2, StorageType type) throws OXException {
        HashMap<Integer, Set<ExternalParticipant>> retval = new HashMap<Integer, Set<ExternalParticipant>>();
        if (StorageType.REMOVED == type) {
            return retval;
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(DBUtils.getIN(SQL.SELECT_EXTERNAL.get((Object)type), tasks2.length));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            for (int taskId : tasks2) {
                stmt.setInt(pos++, taskId);
            }
            result = stmt.executeQuery();
            while (result.next()) {
                pos = 1;
                int taskId = result.getInt(pos++);
                ExternalUserParticipant external = new ExternalUserParticipant(result.getString(pos++));
                external.setDisplayName(result.getString(pos++));
                ExternalParticipant participant = new ExternalParticipant(external);
                HashSet<ExternalParticipant> participants = (HashSet<ExternalParticipant>)retval.get(taskId);
                if (null == participants) {
                    participants = new HashSet<ExternalParticipant>();
                    retval.put(taskId, participants);
                }
                participants.add(participant);
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }

    @Override
    void deleteExternal(Context ctx, Connection con, int taskId, String[] addresses, StorageType type, boolean check) throws OXException {
        if (0 == addresses.length || StorageType.REMOVED == type) {
            return;
        }
        PreparedStatement stmt = null;
        int deleted = 0;
        try {
            stmt = con.prepareStatement(DBUtils.getIN(SQL.DELETE_EXTERNAL.get((Object)type), addresses.length));
            int counter = 1;
            stmt.setInt(counter++, ctx.getContextId());
            stmt.setInt(counter++, taskId);
            for (String address : addresses) {
                stmt.setString(counter++, address);
            }
            deleted = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
        if (check && addresses.length != deleted) {
            OXException exc = TaskExceptionCode.PARTICIPANT_DELETE_WRONG.create(addresses.length, deleted);
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertExternals(Context ctx, Connection con, int taskId, Set<ExternalParticipant> participants, StorageType type) throws OXException {
        if (0 == participants.size()) return;
        if (StorageType.REMOVED == type) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL.INSERT_EXTERNAL.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, taskId);
            for (ExternalParticipant participant : participants) {
                pos = 3;
                stmt.setString(pos++, participant.getMail());
                String displayName = participant.getDisplayName();
                if (null == displayName) {
                    stmt.setNull(pos++, 12);
                } else {
                    stmt.setString(pos++, displayName);
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (DataTruncation e) {
            try {
                throw RdbParticipantStorage.parseTruncatedE(con, e, type, participants);
                catch (SQLException e2) {
                    throw TaskExceptionCode.SQL_ERROR.create(e2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    private static OXException parseTruncatedE(Connection con, DataTruncation dt, StorageType type, Set<ExternalParticipant> participants) {
        OXException tske;
        String[] fields = DBUtils.parseTruncatedFields(dt);
        OXException.Truncated[] truncateds = new OXException.Truncated[fields.length];
        StringBuilder sFields = new StringBuilder();
        int tmp = 0;
        for (ExternalParticipant participant : participants) {
            tmp = Math.max(tmp, participant.getMail().length());
            if (null == participant.getDisplayName()) continue;
            tmp = Math.max(tmp, participant.getDisplayName().length());
        }
        final int maxLength = tmp;
        for (int i = 0; i < fields.length; ++i) {
            sFields.append(fields[i]);
            sFields.append(", ");
            tmp = 0;
            try {
                tmp = DBUtils.getColumnSize(con, SQL.EPARTS_TABLES.get((Object)type), fields[i]);
                if (-1 == tmp) {
                    tmp = 0;
                }
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                tmp = 0;
            }
            final int maxSize = tmp;
            truncateds[i] = new OXException.Truncated(){

                public int getId() {
                    return -1;
                }

                public int getLength() {
                    return maxLength;
                }

                public int getMaxSize() {
                    return maxSize;
                }
            };
        }
        sFields.setLength(sFields.length() - 1);
        if (truncateds.length > 0) {
            OXException.Truncated truncated = truncateds[0];
            tske = TaskExceptionCode.TRUNCATED.create(dt, sFields.toString(), truncated.getMaxSize(), truncated.getLength());
        } else {
            tske = TaskExceptionCode.TRUNCATED.create(dt, sFields.toString(), 0, 0);
        }
        for (OXException.Truncated truncated : truncateds) {
            tske.addProblematic((OXException.ProblematicAttribute)truncated);
        }
        return tske;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertInternals(Context ctx, Connection con, int taskId, Set<InternalParticipant> participants, StorageType type) throws OXException {
        if (0 == participants.size()) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL.INSERT_PARTS.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, taskId);
            for (InternalParticipant participant : participants) {
                pos = 3;
                stmt.setInt(pos++, participant.getIdentifier());
                if (null == participant.getGroupId()) {
                    stmt.setNull(pos++, 4);
                } else {
                    stmt.setInt(pos++, participant.getGroupId());
                }
                stmt.setInt(pos++, participant.getConfirm());
                if (null == participant.getConfirmMessage()) {
                    stmt.setNull(pos++, 12);
                } else {
                    stmt.setString(pos++, participant.getConfirmMessage());
                }
                if (StorageType.REMOVED == type) {
                    int folderId = participant.getFolderId();
                    if (-1 == folderId) {
                        stmt.setInt(pos++, 0);
                    } else {
                        stmt.setInt(pos++, participant.getFolderId());
                    }
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (DataTruncation e) {
            try {
                throw RdbParticipantStorage.parseTruncated(con, e, type, participants);
                catch (SQLException e2) {
                    throw TaskExceptionCode.SQL_ERROR.create(e2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    private static OXException parseTruncated(Connection con, DataTruncation dt, StorageType type, Set<InternalParticipant> participants) {
        String field = "description";
        int tmp = 0;
        for (InternalParticipant participant : participants) {
            tmp = Math.max(tmp, participant.getConfirmMessage().length());
        }
        final int maxLength = tmp;
        try {
            tmp = DBUtils.getColumnSize(con, SQL.EPARTS_TABLES.get((Object)type), "description");
            if (-1 == tmp) {
                tmp = 0;
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            tmp = 0;
        }
        final int maxSize = tmp;
        OXException tske = TaskExceptionCode.TRUNCATED.create(dt, "description", maxSize, maxLength);
        tske.addProblematic((OXException.ProblematicAttribute)new OXException.Truncated(){

            public int getId() {
                return -1;
            }

            public int getLength() {
                return maxLength;
            }

            public int getMaxSize() {
                return maxSize;
            }
        });
        return tske;
    }
}

