/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MsisdnUtility;
import com.openexchange.session.Session;
import java.util.ArrayList;
import java.util.HashSet;
import javax.mail.internet.InternetAddress;

public class SendAddress
implements PreferencesItemService {
    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "sendaddress"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new IValueHandler(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                UserSettingMail settings = UserSettingMailStorage.getInstance().getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    setting.setSingleValue(settings.getSendAddr());
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                boolean supportMsisdnAddresses;
                String newAlias = setting.getSingleValue().toString();
                boolean found = false;
                String[] aliases = user.getAliases();
                ArrayList<String> allAliases = new ArrayList<String>(aliases.length + 3);
                if (aliases != null) {
                    for (String alias : aliases) {
                        allAliases.add(alias);
                    }
                }
                if (supportMsisdnAddresses = MailProperties.getInstance().isSupportMsisdnAddresses()) {
                    HashSet<InternetAddress> msisdnAddresses = new HashSet<InternetAddress>();
                    MsisdnUtility.addMsisdnAddress(msisdnAddresses, session);
                    for (InternetAddress internetAddress : msisdnAddresses) {
                        allAliases.add(internetAddress.getAddress());
                    }
                }
                int pos = newAlias.indexOf(47);
                String checkAlias = newAlias;
                if (pos > 0) {
                    checkAlias = checkAlias.substring(0, pos);
                }
                for (String alias : allAliases) {
                    found = alias.equals(checkAlias);
                }
                if (user.getMail().equals(newAlias)) {
                    found = true;
                }
                if (!found) {
                    throw SettingExceptionCodes.INVALID_VALUE.create(newAlias, setting.getName());
                }
                UserSettingMailStorage storage = UserSettingMailStorage.getInstance();
                UserSettingMail settings = storage.getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    settings.setSendAddr(newAlias);
                    storage.saveUserSettingMail(settings, user.getId(), ctx);
                }
            }

            @Override
            public int getId() {
                return -1;
            }
        };
    }
}

