/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.groupware.reminder.ReminderConfig;
import com.openexchange.groupware.reminder.ReminderEvent;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.TimerService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReminderPool
implements Runnable {
    private static final Map<String, ReminderEvent> register = new HashMap<String, ReminderEvent>();
    private static final Set<ReminderObject> pool = new HashSet<ReminderObject>();
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ReminderPool.class));

    public ReminderPool(ReminderConfig reminderConfig) {
        if (reminderConfig.isReminderEnabled()) {
            TimerService timer;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Starting ReminderPool");
            }
            if ((timer = ServerServiceRegistry.getInstance().getService(TimerService.class)) != null) {
                timer.schedule((Runnable)this, (long)reminderConfig.getReminderInterval());
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"ReminderPool is disabled");
        }
    }

    @Override
    public void run() {
    }

    public static void addReminderEvent(ReminderEvent reminderevent, int module) {
        register.put(String.valueOf(module), reminderevent);
    }

    public static void add(ReminderObject reminderobject) {
        pool.add(reminderobject);
    }

    public static void remove(ReminderObject reminderobject) {
        pool.remove(reminderobject);
    }
}

