/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.webdav.PropertyStore;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.webdav.protocol.WebdavProperty;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyStoreImpl
extends DBService
implements PropertyStore {
    private String INSERT = "INSERT INTO %%tablename%% (cid, id, name, namespace, value, language, xml) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private String tablename;

    public PropertyStoreImpl(String tablename) {
        this(null, tablename);
    }

    public PropertyStoreImpl(DBProvider provider, String tablename) {
        this.setProvider(provider);
        this.initTable(tablename);
    }

    private void initTable(String tablename) {
        this.INSERT = this.INSERT.replaceAll("%%tablename%%", tablename);
        this.tablename = tablename;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<Integer, List<WebdavProperty>> loadProperties(List<Integer> entities, List<WebdavProperty> properties, Context ctx) throws OXException {
        HashMap<Integer, List<WebdavProperty>> hashMap;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuilder builder = new StringBuilder("SELECT id, name, namespace, value, language, xml FROM ");
        builder.append(this.tablename);
        builder.append(" WHERE CID = ? AND id IN (");
        this.join(entities, builder);
        builder.append(") AND (");
        this.addOr(builder, properties);
        builder.append(')');
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(builder.toString());
            stmt.setInt(1, ctx.getContextId());
            this.addOr(stmt, properties, 1);
            rs = stmt.executeQuery();
            HashMap<Integer, List<WebdavProperty>> retVal = new HashMap<Integer, List<WebdavProperty>>();
            while (rs.next()) {
                Integer id = Autoboxing.I((int)rs.getInt(1));
                ArrayList<WebdavProperty> props = (ArrayList<WebdavProperty>)retVal.get(id);
                if (props == null) {
                    props = new ArrayList<WebdavProperty>();
                    retVal.put(id, props);
                }
                props.add(this.getProperty(rs));
            }
            hashMap = retVal;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, builder.toString());
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return hashMap;
    }

    private WebdavProperty getProperty(ResultSet rs) throws SQLException {
        WebdavProperty prop = new WebdavProperty();
        prop.setName(rs.getString("name"));
        prop.setNamespace(rs.getString("namespace"));
        prop.setLanguage(rs.getString("language"));
        prop.setXML(rs.getBoolean("xml"));
        prop.setValue(rs.getString("value"));
        return prop;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<WebdavProperty> loadProperties(int entity, List<WebdavProperty> properties, Context ctx) throws OXException {
        ArrayList<WebdavProperty> arrayList;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuilder builder = new StringBuilder("SELECT id, name, namespace, value, language, xml FROM ");
        builder.append(this.tablename);
        builder.append(" WHERE CID = ? AND id = ");
        builder.append(entity);
        builder.append(" AND (");
        this.addOr(builder, properties);
        builder.append(')');
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(builder.toString());
            stmt.setInt(1, ctx.getContextId());
            this.addOr(stmt, properties, 1);
            rs = stmt.executeQuery();
            ArrayList<WebdavProperty> props = new ArrayList<WebdavProperty>();
            while (rs.next()) {
                props.add(this.getProperty(rs));
            }
            arrayList = props;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, builder.toString());
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveProperties(int entity, List<WebdavProperty> properties, Context ctx) throws OXException {
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = this.getWriteConnection(ctx);
            this.removeProperties(entity, properties, ctx, writeCon);
            stmt = writeCon.prepareStatement(this.INSERT);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            for (WebdavProperty prop : properties) {
                this.setValues(stmt, prop);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, writeCon);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, writeCon);
    }

    private final void setValues(PreparedStatement stmt, WebdavProperty prop) throws SQLException {
        stmt.setString(3, prop.getName());
        stmt.setString(4, prop.getNamespace());
        stmt.setString(5, prop.getValue());
        stmt.setString(6, prop.getLanguage());
        stmt.setBoolean(7, prop.isXML());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<WebdavProperty> loadAllProperties(int entity, Context ctx) throws OXException {
        ArrayList<WebdavProperty> arrayList;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder builder = new StringBuilder("SELECT id, name, namespace, value, language, xml FROM ");
            builder.append(this.tablename);
            builder.append(" WHERE CID = ? AND id = ");
            builder.append(entity);
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(builder.toString());
            stmt.setInt(1, ctx.getContextId());
            rs = stmt.executeQuery();
            ArrayList<WebdavProperty> props = new ArrayList<WebdavProperty>();
            while (rs.next()) {
                props.add(this.getProperty(rs));
            }
            arrayList = props;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<Integer, List<WebdavProperty>> loadAllProperties(List<Integer> entities, Context ctx) throws OXException {
        HashMap<Integer, List<WebdavProperty>> hashMap;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder builder = new StringBuilder("SELECT id, name, namespace, value, language, xml FROM ");
            builder.append(this.tablename);
            builder.append(" WHERE CID = ? AND id IN (");
            this.join(entities, builder);
            builder.append(')');
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(builder.toString());
            stmt.setInt(1, ctx.getContextId());
            rs = stmt.executeQuery();
            HashMap<Integer, List<WebdavProperty>> retVal = new HashMap<Integer, List<WebdavProperty>>();
            while (rs.next()) {
                Integer id = Autoboxing.I((int)rs.getInt(1));
                ArrayList<WebdavProperty> props = (ArrayList<WebdavProperty>)retVal.get(id);
                if (props == null) {
                    props = new ArrayList<WebdavProperty>();
                    retVal.put(id, props);
                }
                props.add(this.getProperty(rs));
            }
            hashMap = retVal;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return hashMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeAll(List<Integer> entities, Context ctx) throws OXException {
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            StringBuilder b = new StringBuilder("DELETE FROM ");
            b.append(this.tablename);
            b.append(" WHERE cid = ");
            b.append(ctx.getContextId());
            b.append(" AND id IN (");
            this.join(entities, b);
            b.append(')');
            writeCon = this.getWriteConnection(ctx);
            stmt = writeCon.prepareStatement(b.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, writeCon);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, writeCon);
    }

    private final void join(List<Integer> entities, StringBuilder b) {
        for (int entity : entities) {
            b.append(entity);
            b.append(',');
        }
        b.setLength(b.length() - 1);
    }

    @Override
    public void removeProperties(int entity, List<WebdavProperty> properties, Context ctx) throws OXException {
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = this.getWriteConnection(ctx);
            this.removeProperties(entity, properties, ctx, writeCon);
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
        catch (OXException e) {
            throw e;
        }
        finally {
            this.close(stmt, null);
            this.releaseWriteConnection(ctx, writeCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperties(int entity, List<WebdavProperty> properties, Context ctx, Connection writeCon) throws SQLException {
        if (properties.isEmpty()) {
            return;
        }
        PreparedStatement stmt = null;
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        builder.append(this.tablename);
        builder.append(" WHERE cid = ? AND id = ? AND (");
        this.addOr(builder, properties);
        builder.append(')');
        try {
            stmt = writeCon.prepareStatement(builder.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            this.addOr(stmt, properties, 2);
            stmt.executeUpdate();
        }
        finally {
            this.close(stmt, null);
        }
    }

    private final void addOr(PreparedStatement stmt, List<WebdavProperty> properties, int count) throws SQLException {
        for (WebdavProperty property : properties) {
            stmt.setString(++count, property.getName());
            stmt.setString(++count, property.getNamespace());
        }
    }

    private final void addOr(StringBuilder builder, List<WebdavProperty> properties) {
        String append = "(name = ? AND namespace = ?) OR ";
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            builder.append("(name = ? AND namespace = ?) OR ");
        }
        builder.setLength(builder.length() - 3);
    }

    @Override
    public void removeAll(int entity, Context ctx) throws OXException {
        this.removeAll(Arrays.asList(entity), ctx);
    }
}

