/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.InfostoreFilenameReservation;
import com.openexchange.groupware.infostore.database.impl.InfostoreIterator;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SelectForUpdateReservation
implements InfostoreFilenameReservation {
    private static final String REMOVE_RESERVATION_SQL = "DELETE FROM infostoreReservedPaths WHERE cid = ? AND folder = ? AND name = ?";
    private static final String LOCK_FOLDER_SQL = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND fuid = ? FOR UPDATE ";
    private static final String RESERVE_NAME_SQL = "INSERT INTO infostoreReservedPaths (cid, folder, name) VALUES (?, ?, ?)";
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SelectForUpdateReservation.class));
    private final String fileName;
    private final long folderId;
    private final int id;
    private final Context ctx;
    private final DBProvider provider;
    private Connection con;
    private boolean reserved;
    private boolean wasAdjusted;

    public SelectForUpdateReservation(String fileName, long folderId, int id, Context context, DBProvider provider) {
        this.fileName = fileName;
        this.folderId = folderId;
        this.id = id;
        this.ctx = context;
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySilently() {
        try {
            this.openConnection();
            this.removeReservation();
        }
        catch (Exception x) {
            LOG.error((Object)x.getMessage(), (Throwable)x);
        }
        finally {
            this.releaseConnection();
        }
    }

    private void releaseConnection() {
        this.provider.releaseWriteConnection(this.ctx, this.con);
    }

    private void openConnection() throws OXException {
        this.con = this.provider.getWriteConnection(this.ctx);
    }

    public boolean reserve() throws SQLException, OXException {
        if (this.reserved) {
            return true;
        }
        if (!this.mustReserveName()) {
            return true;
        }
        boolean free = false;
        try {
            this.startTransaction();
            this.lockFolder();
            free = this.checkFree();
            if (free) {
                this.reserveFilename();
            }
            this.commit();
        }
        catch (SQLException x) {
            this.rollback();
            throw x;
        }
        finally {
            this.finishTransaction();
        }
        this.reserved = free;
        return this.reserved;
    }

    protected boolean mustReserveName() {
        if (null == this.fileName) {
            return false;
        }
        return !"".equals(this.fileName.trim());
    }

    private void finishTransaction() throws SQLException {
        this.con.setAutoCommit(true);
        this.releaseConnection();
    }

    private void rollback() throws SQLException {
        this.con.rollback();
    }

    private void commit() throws SQLException {
        this.con.commit();
    }

    private void reserveFilename() throws SQLException {
        this.exec(RESERVE_NAME_SQL, this.ctx.getContextId(), this.folderId, this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFree() throws OXException, SQLException {
        InfostoreIterator iter = null;
        try {
            iter = InfostoreIterator.documentsByFilename(this.folderId, this.fileName, new Metadata[]{Metadata.ID_LITERAL, Metadata.TITLE_LITERAL}, new StaticDBPoolProvider(this.con), this.ctx);
            while (iter.hasNext()) {
                DocumentMetadata dm = iter.next();
                if (dm.getId() == this.id) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
        return !this.hasResult("SELECT 1 FROM infostoreReservedPaths WHERE cid = ? AND folder = ? AND name = ?", this.ctx.getContextId(), this.folderId, this.fileName);
    }

    private void lockFolder() throws SQLException {
        this.exec(LOCK_FOLDER_SQL, this.ctx.getContextId(), this.folderId);
    }

    private void removeReservation() throws SQLException {
        if (!this.reserved) {
            return;
        }
        this.exec(REMOVE_RESERVATION_SQL, this.ctx.getContextId(), this.folderId, this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(String sql, Object ... replacements) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql);
        try {
            for (int i = 0; i < replacements.length; ++i) {
                stmt.setObject(i + 1, replacements[i]);
            }
            stmt.execute();
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResult(String sql, Object ... replacements) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql);
        ResultSet rs = null;
        try {
            for (int i = 0; i < replacements.length; ++i) {
                stmt.setObject(i + 1, replacements[i]);
            }
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        finally {
            stmt.close();
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void startTransaction() throws OXException, SQLException {
        this.openConnection();
        this.con.setAutoCommit(false);
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    @Override
    public boolean wasAdjusted() {
        return this.wasAdjusted;
    }

    @Override
    public void setWasAdjusted(boolean wasAdjusted) {
        this.wasAdjusted = wasAdjusted;
    }
}

