/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.impl.id;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.id.IDExceptionCodes;
import com.openexchange.id.IDGeneratorService;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class IDGeneratorServiceImpl
implements IDGeneratorService {
    public int getId(String type, int contextId) throws OXException {
        return this.getId(type, contextId, 1);
    }

    public int getId(String type, int contextId, int minId) throws OXException {
        Connection con = IDGeneratorServiceImpl.getWritableConnection(contextId);
        try {
            int id = IDGeneratorServiceImpl.getId(type, contextId, minId, con);
            if (id < 0) {
                throw IDExceptionCodes.ID_GEN_FAILED.create();
            }
            int n = id;
            return n;
        }
        catch (SQLException e) {
            throw IDExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            throw IDExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Database.back(contextId, true, con);
        }
    }

    private static Connection getWritableConnection(int contextId) throws OXException {
        return Database.get(contextId, true);
    }

    private static int getId(String type, int contextId, int minId, Connection con) throws SQLException {
        int retval = -1;
        int retry = 0;
        boolean tryInsert = true;
        while (retval < 0 && retry++ < 5) {
            int increment;
            int cur;
            do {
                if ((cur = IDGeneratorServiceImpl.performSelect(type, contextId, con)) >= 0) continue;
                if (tryInsert) {
                    if (IDGeneratorServiceImpl.performInsert(type, contextId, minId, con)) {
                        return minId;
                    }
                    tryInsert = false;
                }
                cur = IDGeneratorServiceImpl.performSelect(type, contextId, con);
            } while (!IDGeneratorServiceImpl.compareAndSet(type, contextId, cur, cur + (increment = cur < minId ? minId - cur : 1), con) && retry++ < 5);
            retval = cur + increment;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareAndSet(String type, int contextId, int expected, int newValue, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE sequenceIds SET id = ? WHERE cid = ? AND type = ? AND id = ?");
            stmt.setInt(1, newValue);
            stmt.setInt(2, contextId);
            stmt.setString(3, type);
            stmt.setInt(4, expected);
            int result = stmt.executeUpdate();
            boolean bl = result > 0;
            return bl;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int performSelect(String type, int contextId, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            int n;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("SELECT id FROM sequenceIds WHERE cid = ? AND type = ?");
                stmt.setInt(1, contextId);
                stmt.setString(2, type);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return n;
        }
        int n = -1;
        DBUtils.closeSQLStuff(rs, stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean performInsert(String type, int contextId, int firstValue, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO sequenceIds (cid, type, id) VALUES (?, ?, ?)");
            stmt.setInt(1, contextId);
            stmt.setString(2, type);
            stmt.setInt(3, firstValue);
            try {
                int result = stmt.executeUpdate();
                boolean bl = result > 0;
                return bl;
            }
            catch (SQLException e) {
                boolean bl = false;
                DBUtils.closeSQLStuff(stmt);
                return bl;
            }
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

