/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.filestore;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.filestore.Filestore;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.sql.Connection;

public class CachingFilestoreStorage
extends FilestoreStorage {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CachingFilestoreStorage.class));
    private static final String REGION_NAME = "Filestore";
    private final FilestoreStorage delegate;

    public CachingFilestoreStorage(FilestoreStorage fs) {
        this.delegate = fs;
    }

    @Override
    public Filestore getFilestore(int id) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getFilestore(id);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)Autoboxing.I((int)id));
        if (object instanceof Filestore) {
            return (Filestore)object;
        }
        Filestore filestore = this.delegate.getFilestore(id);
        cache.put((Serializable)Autoboxing.I((int)id), (Serializable)filestore, false);
        return filestore;
    }

    @Override
    public Filestore getFilestore(Connection con, int id) throws OXException {
        CacheService service = ServerServiceRegistry.getInstance().getService(CacheService.class);
        Cache filestoreCache = null;
        if (service != null) {
            try {
                filestoreCache = service.getCache(REGION_NAME);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Filestore retval = null;
        if (null != filestoreCache) {
            retval = (Filestore)filestoreCache.get((Serializable)Autoboxing.I((int)id));
        }
        if (null == retval) {
            retval = this.delegate.getFilestore(con, id);
            if (null != filestoreCache) {
                try {
                    filestoreCache.put((Serializable)Autoboxing.I((int)id), (Serializable)retval, false);
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return retval;
    }
}

