/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.downgrade;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;

public enum DowngradeFailedExceptionCodes {
    SQL_ERROR("A SQL error occurred: %1$s", Category.CATEGORY_ERROR, 1),
    ERROR("An error occurred: %1$s", Category.CATEGORY_ERROR, 2);

    private final String message;
    private final Category category;
    private final int detailNumber;
    private static final String PREFIX = "DOW";

    private DowngradeFailedExceptionCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public OXException create() {
        return this.create(new Object[0]);
    }

    public OXException create(Object ... logArguments) {
        return this.create(null, logArguments);
    }

    public OXException create(Throwable cause, Object ... logArguments) {
        return new OXException(this.detailNumber, "An error occurred inside the Open-Xchange server which prevented it from fulfilling the request.", cause, new Object[0]).setPrefix(PREFIX).addCategory(this.category).setLogMessage(this.message, logArguments);
    }
}

