/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.delete;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class POP3DeleteListener
implements DeleteListener {
    POP3DeleteListener() {
    }

    @Override
    public void deletePerformed(DeleteEvent deleteEvent, Connection readCon, Connection writeCon) throws OXException {
        if (1 == deleteEvent.getType()) {
            PreparedStatement stmt = null;
            try {
                int contextId = deleteEvent.getContext().getContextId();
                int user = deleteEvent.getId();
                stmt = writeCon.prepareStatement("DELETE FROM pop3_storage_deleted WHERE cid=? AND user=?");
                int pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, user);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(stmt);
                stmt = writeCon.prepareStatement("DELETE FROM pop3_storage_ids WHERE cid=? AND user=?");
                pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, user);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

