/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.SystemObject;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public abstract class DataObject
extends SystemObject {
    private static final long serialVersionUID = 4792432831176202196L;
    public static final int OBJECT_ID = 1;
    public static final int CREATED_BY = 2;
    public static final int MODIFIED_BY = 3;
    public static final int CREATION_DATE = 4;
    public static final int LAST_MODIFIED = 5;
    public static final int LAST_MODIFIED_UTC = 6;
    protected int objectId;
    protected int createdBy;
    protected int modifiedBy;
    protected Date creationDate;
    protected Date lastModified;
    protected boolean b_object_id;
    protected boolean b_created_by;
    protected boolean b_modified_by;
    protected boolean b_creation_date;
    protected boolean b_last_modified;

    public int getObjectID() {
        return this.objectId;
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setObjectID(int object_id) {
        this.objectId = object_id;
        this.b_object_id = true;
    }

    public void setCreatedBy(int created_by) {
        this.createdBy = created_by;
        this.b_created_by = true;
    }

    public void setModifiedBy(int modified_by) {
        this.modifiedBy = modified_by;
        this.b_modified_by = true;
    }

    public void setCreationDate(Date creation_date) {
        this.creationDate = creation_date;
        this.b_creation_date = true;
    }

    public void setLastModified(Date last_modified) {
        this.lastModified = last_modified;
        this.b_last_modified = true;
    }

    public void removeObjectID() {
        this.objectId = 0;
        this.b_object_id = false;
    }

    public void removeCreatedBy() {
        this.createdBy = 0;
        this.b_created_by = false;
    }

    public void removeModifiedBy() {
        this.modifiedBy = 0;
        this.b_modified_by = false;
    }

    public void removeCreationDate() {
        this.creationDate = null;
        this.b_creation_date = false;
    }

    public void removeLastModified() {
        this.lastModified = null;
        this.b_last_modified = false;
    }

    public boolean containsObjectID() {
        return this.b_object_id;
    }

    public boolean containsCreatedBy() {
        return this.b_created_by;
    }

    public boolean containsModifiedBy() {
        return this.b_modified_by;
    }

    public boolean containsCreationDate() {
        return this.b_creation_date;
    }

    public boolean containsLastModified() {
        return this.b_last_modified;
    }

    public void reset() {
        this.objectId = 0;
        this.createdBy = 0;
        this.modifiedBy = 0;
        this.creationDate = null;
        this.lastModified = null;
        this.b_object_id = false;
        this.b_created_by = false;
        this.b_modified_by = false;
        this.b_creation_date = false;
        this.b_last_modified = false;
    }

    public Set<Integer> findDifferingFields(DataObject other) {
        HashSet<Integer> differingFields = new HashSet<Integer>();
        if (!this.containsCreatedBy() && other.containsCreatedBy() || this.containsCreatedBy() && other.containsCreatedBy() && this.getCreatedBy() != other.getCreatedBy()) {
            differingFields.add(2);
        }
        if (!this.containsCreationDate() && other.containsCreationDate() || this.containsCreationDate() && other.containsCreationDate() && this.getCreationDate() != other.getCreationDate() && (this.getCreationDate() == null || !this.getCreationDate().equals(other.getCreationDate()))) {
            differingFields.add(4);
        }
        if (!this.containsLastModified() && other.containsLastModified() || this.containsLastModified() && other.containsLastModified() && this.getLastModified() != other.getLastModified() && (this.getLastModified() == null || !this.getLastModified().equals(other.getLastModified()))) {
            differingFields.add(5);
        }
        if (!this.containsModifiedBy() && other.containsModifiedBy() || this.containsModifiedBy() && other.containsModifiedBy() && this.getModifiedBy() != other.getModifiedBy()) {
            differingFields.add(3);
        }
        if (!this.containsObjectID() && other.containsObjectID() || this.containsObjectID() && other.containsObjectID() && this.getObjectID() != other.getObjectID()) {
            differingFields.add(1);
        }
        return differingFields;
    }

    public void set(int field, Object value) {
        switch (field) {
            case 5: 
            case 6: {
                this.setLastModified((Date)value);
                break;
            }
            case 1: {
                this.setObjectID((Integer)value);
                break;
            }
            case 3: {
                this.setModifiedBy((Integer)value);
                break;
            }
            case 4: {
                this.setCreationDate((Date)value);
                break;
            }
            case 2: {
                this.setCreatedBy((Integer)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("I don't know how to set " + field);
            }
        }
    }

    public Object get(int field) {
        switch (field) {
            case 5: 
            case 6: {
                return this.getLastModified();
            }
            case 1: {
                return this.getObjectID();
            }
            case 3: {
                return this.getModifiedBy();
            }
            case 4: {
                return this.getCreationDate();
            }
            case 2: {
                return this.getCreatedBy();
            }
        }
        throw new IllegalArgumentException("I don't know how to get " + field);
    }

    public boolean contains(int field) {
        switch (field) {
            case 5: 
            case 6: {
                return this.containsLastModified();
            }
            case 1: {
                return this.containsObjectID();
            }
            case 3: {
                return this.containsModifiedBy();
            }
            case 4: {
                return this.containsCreationDate();
            }
            case 2: {
                return this.containsCreatedBy();
            }
        }
        throw new IllegalArgumentException("I don't know about field " + field);
    }

    public void remove(int field) {
        switch (field) {
            case 5: {
                this.removeLastModified();
                break;
            }
            case 1: {
                this.removeObjectID();
                break;
            }
            case 3: {
                this.removeModifiedBy();
                break;
            }
            case 4: {
                this.removeCreationDate();
                break;
            }
            case 2: {
                this.removeCreatedBy();
                break;
            }
            case 6: {
                this.removeLastModified();
                break;
            }
            default: {
                throw new IllegalArgumentException("I don't know how to remove field " + field);
            }
        }
    }
}

