/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.groupware.contact.helpers.SpecialAlphanumSortContactComparator;
import com.openexchange.groupware.container.Contact;
import java.util.Comparator;
import java.util.Locale;

public class UseCountComparator
implements Comparator<Contact> {
    private Comparator<Contact> contactComparator;
    private final boolean specialSort;

    public UseCountComparator(boolean specialSort, Locale locale) {
        this.specialSort = specialSort;
        this.contactComparator = new SpecialAlphanumSortContactComparator(locale);
    }

    public UseCountComparator(boolean specialSort, Comparator<Contact> comp) {
        this(specialSort, Locale.US);
        this.contactComparator = comp;
    }

    @Override
    public int compare(Contact o1, Contact o2) {
        if (o1.getParentFolderID() == 6 && o2.getParentFolderID() == 6) {
            if (this.specialSort) {
                return this.contactComparator.compare(o1, o2);
            }
            return 0;
        }
        if (o1.getParentFolderID() != 6 && o2.getParentFolderID() != 6) {
            return o2.getUseCount() - o1.getUseCount();
        }
        if (o1.getParentFolderID() == 6) {
            return -1;
        }
        if (o2.getParentFolderID() == 6) {
            return 1;
        }
        return 0;
    }
}

