/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

public enum CalendarField {
    OBJECTID(1, "ObjectID"),
    CREATEDBY(2, "CreatedBy"),
    CREATIONDATE(4, "CreationDate"),
    MODIFIEDBY(3, "ModifiedBy"),
    LASTMODIFIED(5, "LastModified"),
    PARENTFOLDERID(20, "ParentFolderID"),
    TITLE(200, "Title"),
    STARTDATE(201, "StartDate"),
    ENDDATE(202, "EndDate"),
    SHOWNAS(402, "ShownAs"),
    LOCATION(400, "Location"),
    CATEGORIES(100, "Categories"),
    LABEL(102, "Label"),
    PRIVATEFLAG(101, "PrivateFlag"),
    FULLTIME(401, "FullTime"),
    NOTE(203, "Note"),
    RECURRENCETYPE(209, "RecurrenceType"),
    INTERVAL(215, "Interval"),
    DAYS(212, "Days"),
    DAYINMONTH(213, "DayInMonth"),
    MONTH(214, "Month"),
    UNTIL(216, "Until"),
    OCCURRENCE(222, "Occurrence"),
    RECURRENCEDATEPOSITION(208, "RecurrenceDatePosition"),
    RECURRENCEPOSITION(207, "RecurrencePosition"),
    TIMEZONE(408, "Timezone"),
    CHANGEEXCEPTION(210, "ChangeExceptions"),
    DELETEEXCEPTION(211, "DeleteExceptions"),
    PARTICIPANTS(220, "Participants"),
    USERS(221, "Users"),
    RECURRINGOCCURRENCE(217, "Notification"),
    RECURRENCECALCULATOR(218, "RecurrenceCalculator"),
    ALARM(204, "Alarm");

    private int appointmentObjectID;
    private String name;

    private CalendarField(int appointmentObjectID, String name) {
        this.appointmentObjectID = appointmentObjectID;
        this.name = name;
    }

    public static CalendarField getByAppointmentObjectId(int id) {
        for (CalendarField field : CalendarField.values()) {
            if (id != field.getAppointmentObjectID()) continue;
            return field;
        }
        return null;
    }

    public static CalendarField getByName(String name) {
        for (CalendarField field : CalendarField.values()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public int getAppointmentObjectID() {
        return this.appointmentObjectID;
    }

    public void setAppointmentObjectID(int appointmentObjectID) {
        this.appointmentObjectID = appointmentObjectID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getICalElement() {
        return this.name;
    }
}

