/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;

@Action(method=RequestMethod.GET, name="[filename]?action=document", description="Get an attachments filedata.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="attached", description="Object ID of the object to which the attachments are attached."), @Parameter(name="module", description="Module ID (as per Attachment object) of the attached object."), @Parameter(name="id", description="Object ID of the requested attachment."), @Parameter(name="content_type", optional=true, description="If set the responses Content-Type header is set to this value, not the attachements file mime type.")}, responseDescription="The raw byte data of the document. The response type for the HTTP Request is set accordingly to the defined mimetype for this infoitem. Note: The Filename may be added to the customary infostore path to suggest a filename to a Save-As dialog.")
public final class GetDocumentAction
extends AbstractAttachmentAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GetDocumentAction.class));
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    public GetDocumentAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        GetDocumentAction.require(requestData, "folder", "attached", "module", "id");
        String contentType = requestData.getParameter("content_type");
        int folderId = this.requireNumber(requestData, "folder");
        int attachedId = this.requireNumber(requestData, "attached");
        int moduleId = this.requireNumber(requestData, "module");
        int id = this.requireNumber(requestData, "id");
        if (!requestData.getFormat().equals("preview_image")) {
            requestData.setFormat("file");
        }
        return this.document(session, folderId, attachedId, moduleId, id, contentType, requestData.getParameter(AJAXServlet.PARAMETER_DELIVERY), session.getContext(), session.getUser(), session.getUserConfiguration(), requestData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult document(Session session, int folderId, int attachedId, int moduleId, int id, String contentType, String delivery, Context ctx, User user, UserConfiguration userConfig, AJAXRequestData requestData) throws OXException {
        try {
            OutputStream directOutputStream;
            String fileName;
            StringAllocator sb;
            String sContentType;
            ATTACHMENT_BASE.startTransaction();
            AttachmentMetadata attachment = ATTACHMENT_BASE.getAttachment(session, folderId, attachedId, moduleId, id, ctx, user, userConfig);
            if (null == contentType || APPLICATION_OCTET_STREAM.equals(this.toLowerCase(contentType))) {
                sContentType = APPLICATION_OCTET_STREAM;
            } else {
                String primaryType2;
                String primaryType1;
                String contentTypeByFileName = MimeType2ExtMap.getContentType(attachment.getFilename());
                String preferredContentType = attachment.getFileMIMEType();
                if (!APPLICATION_OCTET_STREAM.equals(contentTypeByFileName)) {
                    if (APPLICATION_OCTET_STREAM.equals(preferredContentType)) {
                        preferredContentType = contentTypeByFileName;
                    } else {
                        primaryType1 = this.getPrimaryType(preferredContentType);
                        primaryType2 = this.getPrimaryType(contentTypeByFileName);
                        if (!this.toLowerCase(primaryType1).startsWith(this.toLowerCase(primaryType2))) {
                            preferredContentType = contentTypeByFileName;
                        }
                    }
                }
                primaryType1 = this.getPrimaryType(preferredContentType);
                primaryType2 = this.getPrimaryType(contentType);
                if (this.toLowerCase(primaryType1).startsWith(this.toLowerCase(primaryType2))) {
                    sContentType = contentType;
                } else {
                    sb = new StringAllocator(128);
                    sb.append("Denied parameter \"").append("content_type").append("\" due to security constraints (");
                    sb.append(contentType).append(" vs. ").append(preferredContentType).append(").");
                    LOG.warn((Object)sb.toString());
                    sContentType = preferredContentType;
                }
            }
            InputStream documentData = ATTACHMENT_BASE.getAttachedFile(session, folderId, attachedId, moduleId, id, ctx, user, userConfig);
            boolean isImage = false;
            String lc = this.toLowerCase(sContentType);
            if (lc.startsWith("image/") || requestData.getFormat().equals("preview_image")) {
                isImage = true;
            } else if (lc.startsWith(APPLICATION_OCTET_STREAM) && null != (fileName = attachment.getFilename()) && MimeType2ExtMap.getContentType(fileName).startsWith("image/")) {
                isImage = true;
            }
            if (!isImage && null != (directOutputStream = requestData.optOutputStream())) {
                String cts = "download".equalsIgnoreCase(delivery) ? APPLICATION_OCTET_STREAM : sContentType;
                requestData.setResponseHeader("Content-Type", cts);
                sb = new StringAllocator(this.toLowerCase(cts).startsWith(APPLICATION_OCTET_STREAM) ? "attachment" : "inline");
                DownloadUtility.appendFilenameParameter(attachment.getFilename(), null, requestData.getUserAgent(), sb);
                requestData.setResponseHeader("Content-Disposition", sb.toString());
                requestData.removeCachingHeader();
                try {
                    int len;
                    int buflen = 65535;
                    byte[] buffer = new byte[65535];
                    while ((len = documentData.read(buffer, 0, 65535)) > 0) {
                        directOutputStream.write(buffer, 0, len);
                    }
                    directOutputStream.flush();
                }
                finally {
                    Streams.close((Closeable)documentData);
                }
                AJAXRequestResult aJAXRequestResult = new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct");
                return aJAXRequestResult;
            }
            ThresholdFileHolder fileHolder = new ThresholdFileHolder();
            try {
                fileHolder.write(documentData);
            }
            finally {
                Streams.close((Closeable)documentData);
            }
            fileHolder.setContentType(sContentType);
            fileHolder.setName(attachment.getFilename());
            fileHolder.setDelivery(delivery);
            ATTACHMENT_BASE.commit();
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)fileHolder, "file");
            return aJAXRequestResult;
        }
        catch (Throwable t) {
            this.rollback();
            if (t instanceof OXException) {
                throw (OXException)t;
            }
            throw new OXException(t);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private String getPrimaryType(String contentType) {
        if (this.isEmpty(contentType)) {
            return contentType;
        }
        int pos = contentType.indexOf(47);
        return pos > 0 ? contentType.substring(0, pos) : contentType;
    }
}

